/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetResourcesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetResourcesRequestMarshaller
implements Marshaller<Request<GetResourcesRequest>, GetResourcesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetResourcesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetResourcesRequest> marshall(GetResourcesRequest getResourcesRequest) {
        if (getResourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getResourcesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/resources";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getResourcesRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getResourcesRequest.getRestApiId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getResourcesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getResourcesRequest.getPosition()));
        }
        if (getResourcesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getResourcesRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

