/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.apigateway.model.GetStagesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetStagesRequestMarshaller
implements Marshaller<Request<GetStagesRequest>, GetStagesRequest> {
    private final SdkJsonProtocolFactory protocolFactory;

    public GetStagesRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetStagesRequest> marshall(GetStagesRequest getStagesRequest) {
        if (getStagesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getStagesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/stages";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", getStagesRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)getStagesRequest.getRestApiId()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        if (getStagesRequest.getDeploymentId() != null) {
            request.addParameter("deploymentId", StringUtils.fromString((String)getStagesRequest.getDeploymentId()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

