/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetDocumentationPartsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class GetDocumentationPartsRequestMarshaller
implements Marshaller<Request<GetDocumentationPartsRequest>, GetDocumentationPartsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDocumentationPartsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetDocumentationPartsRequest> marshall(GetDocumentationPartsRequest getDocumentationPartsRequest) {
        if (getDocumentationPartsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getDocumentationPartsRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/restapis/{restapi_id}/documentation/parts";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getDocumentationPartsRequest.getRestApiId());
        request.setResourcePath(uriResourcePath);
        if (getDocumentationPartsRequest.getType() != null) {
            request.addParameter("type", StringUtils.fromString((String)getDocumentationPartsRequest.getType()));
        }
        if (getDocumentationPartsRequest.getNameQuery() != null) {
            request.addParameter("name", StringUtils.fromString((String)getDocumentationPartsRequest.getNameQuery()));
        }
        if (getDocumentationPartsRequest.getPath() != null) {
            request.addParameter("path", StringUtils.fromString((String)getDocumentationPartsRequest.getPath()));
        }
        if (getDocumentationPartsRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString((String)getDocumentationPartsRequest.getPosition()));
        }
        if (getDocumentationPartsRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger((Integer)getDocumentationPartsRequest.getLimit()));
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

