/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetExportRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class GetExportRequestMarshaller
implements Marshaller<Request<GetExportRequest>, GetExportRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetExportRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<GetExportRequest> marshall(GetExportRequest getExportRequest) {
        if (getExportRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getExportRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        if (getExportRequest.getAccepts() != null) {
            request.addHeader("Accept", StringUtils.fromString((String)getExportRequest.getAccepts()));
        }
        String uriResourcePath = "/restapis/{restapi_id}/stages/{stage_name}/exports/{export_type}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", getExportRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "stage_name", getExportRequest.getStageName());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "export_type", getExportRequest.getExportType());
        request.setResourcePath(uriResourcePath);
        Map<String, String> parameters = getExportRequest.getParameters();
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                if (entry.getValue() == null) continue;
                request.addParameter(StringUtils.fromString((String)entry.getKey()), StringUtils.fromString((String)entry.getValue()));
            }
        }
        request.setContent((InputStream)new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

