/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PutMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PutMethodResponseRequestMarshaller
implements Marshaller<Request<PutMethodResponseRequest>, PutMethodResponseRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public PutMethodResponseRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutMethodResponseRequest> marshall(PutMethodResponseRequest putMethodResponseRequest) {
        if (putMethodResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", putMethodResponseRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "resource_id", putMethodResponseRequest.getResourceId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "http_method", putMethodResponseRequest.getHttpMethod());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "status_code", putMethodResponseRequest.getStatusCode());
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseModelsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            Map<String, Boolean> responseParametersMap = putMethodResponseRequest.getResponseParameters();
            if (responseParametersMap != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(((Boolean)responseParametersMapValue.getValue()).booleanValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseModelsMap = putMethodResponseRequest.getResponseModels()) != null) {
                jsonGenerator.writeFieldName("responseModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : responseModelsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

