/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PatchOperation;
import com.amazonaws.services.apigateway.model.UpdateIntegrationResponseRequest;
import com.amazonaws.services.apigateway.model.transform.PatchOperationJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateIntegrationResponseRequestMarshaller
implements Marshaller<Request<UpdateIntegrationResponseRequest>, UpdateIntegrationResponseRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateIntegrationResponseRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateIntegrationResponseRequest> marshall(UpdateIntegrationResponseRequest updateIntegrationResponseRequest) {
        if (updateIntegrationResponseRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateIntegrationResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PATCH);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/integration/responses/{status_code}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", updateIntegrationResponseRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "resource_id", updateIntegrationResponseRequest.getResourceId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "http_method", updateIntegrationResponseRequest.getHttpMethod());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "status_code", updateIntegrationResponseRequest.getStatusCode());
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<PatchOperation> patchOperationsList = updateIntegrationResponseRequest.getPatchOperations();
            if (patchOperationsList != null) {
                jsonGenerator.writeFieldName("patchOperations");
                jsonGenerator.writeStartArray();
                for (PatchOperation patchOperationsListValue : patchOperationsList) {
                    if (patchOperationsListValue == null) continue;
                    PatchOperationJsonMarshaller.getInstance().marshall(patchOperationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

