/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.ImportApiKeysRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.UriResourcePathUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ImportApiKeysRequestMarshaller
implements Marshaller<Request<ImportApiKeysRequest>, ImportApiKeysRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ImportApiKeysRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ImportApiKeysRequest> marshall(ImportApiKeysRequest importApiKeysRequest) {
        if (importApiKeysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importApiKeysRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/apikeys?mode=import";
        uriResourcePath = UriResourcePathUtils.addStaticQueryParamtersToRequest((Request)request, (String)uriResourcePath);
        request.setResourcePath(uriResourcePath);
        if (importApiKeysRequest.getFormat() != null) {
            request.addParameter("format", StringUtils.fromString((String)importApiKeysRequest.getFormat()));
        }
        if (importApiKeysRequest.getFailOnWarnings() != null) {
            request.addParameter("failonwarnings", StringUtils.fromBoolean((Boolean)importApiKeysRequest.getFailOnWarnings()));
        }
        request.setContent((InputStream)BinaryUtils.toStream((ByteBuffer)importApiKeysRequest.getBody()));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

