/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.TestInvokeAuthorizerRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class TestInvokeAuthorizerRequestMarshaller
implements Marshaller<Request<TestInvokeAuthorizerRequest>, TestInvokeAuthorizerRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public TestInvokeAuthorizerRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<TestInvokeAuthorizerRequest> marshall(TestInvokeAuthorizerRequest testInvokeAuthorizerRequest) {
        if (testInvokeAuthorizerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)testInvokeAuthorizerRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/restapis/{restapi_id}/authorizers/{authorizer_id}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "restapi_id", testInvokeAuthorizerRequest.getRestApiId());
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "authorizer_id", testInvokeAuthorizerRequest.getAuthorizerId());
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> additionalContextMap;
            Map<String, String> stageVariablesMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            Map<String, String> headersMap = testInvokeAuthorizerRequest.getHeaders();
            if (headersMap != null) {
                jsonGenerator.writeFieldName("headers");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> headersMapValue : headersMap.entrySet()) {
                    if (headersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)headersMapValue.getKey());
                    jsonGenerator.writeValue((String)headersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (testInvokeAuthorizerRequest.getPathWithQueryString() != null) {
                jsonGenerator.writeFieldName("pathWithQueryString").writeValue(testInvokeAuthorizerRequest.getPathWithQueryString());
            }
            if (testInvokeAuthorizerRequest.getBody() != null) {
                jsonGenerator.writeFieldName("body").writeValue(testInvokeAuthorizerRequest.getBody());
            }
            if ((stageVariablesMap = testInvokeAuthorizerRequest.getStageVariables()) != null) {
                jsonGenerator.writeFieldName("stageVariables");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : stageVariablesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((additionalContextMap = testInvokeAuthorizerRequest.getAdditionalContext()) != null) {
                jsonGenerator.writeFieldName("additionalContext");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> entry : additionalContextMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName(entry.getKey());
                    jsonGenerator.writeValue(entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] byArray = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(byArray));
            request.addHeader("Content-Length", Integer.toString(byArray.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

