/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.Integration;
import com.amazonaws.services.apigateway.model.IntegrationResponse;
import com.amazonaws.services.apigateway.model.transform.IntegrationResponseJsonMarshaller;
import java.util.List;
import java.util.Map;

public class IntegrationJsonMarshaller {
    private static IntegrationJsonMarshaller instance;

    public void marshall(Integration integration, StructuredJsonGenerator jsonGenerator) {
        if (integration == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, IntegrationResponse> map;
            List<String> cacheKeyParametersList;
            Map<String, String> requestTemplatesMap;
            Map<String, String> requestParametersMap;
            jsonGenerator.writeStartObject();
            if (integration.getType() != null) {
                jsonGenerator.writeFieldName("type").writeValue(integration.getType());
            }
            if (integration.getHttpMethod() != null) {
                jsonGenerator.writeFieldName("httpMethod").writeValue(integration.getHttpMethod());
            }
            if (integration.getUri() != null) {
                jsonGenerator.writeFieldName("uri").writeValue(integration.getUri());
            }
            if (integration.getCredentials() != null) {
                jsonGenerator.writeFieldName("credentials").writeValue(integration.getCredentials());
            }
            if ((requestParametersMap = integration.getRequestParameters()) != null) {
                jsonGenerator.writeFieldName("requestParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> requestParametersMapValue : requestParametersMap.entrySet()) {
                    if (requestParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)requestParametersMapValue.getKey());
                    jsonGenerator.writeValue((String)requestParametersMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((requestTemplatesMap = integration.getRequestTemplates()) != null) {
                jsonGenerator.writeFieldName("requestTemplates");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : requestTemplatesMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (integration.getPassthroughBehavior() != null) {
                jsonGenerator.writeFieldName("passthroughBehavior").writeValue(integration.getPassthroughBehavior());
            }
            if (integration.getContentHandling() != null) {
                jsonGenerator.writeFieldName("contentHandling").writeValue(integration.getContentHandling());
            }
            if (integration.getCacheNamespace() != null) {
                jsonGenerator.writeFieldName("cacheNamespace").writeValue(integration.getCacheNamespace());
            }
            if ((cacheKeyParametersList = integration.getCacheKeyParameters()) != null) {
                jsonGenerator.writeFieldName("cacheKeyParameters");
                jsonGenerator.writeStartArray();
                for (String cacheKeyParametersListValue : cacheKeyParametersList) {
                    if (cacheKeyParametersListValue == null) continue;
                    jsonGenerator.writeValue(cacheKeyParametersListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((map = integration.getIntegrationResponses()) != null) {
                jsonGenerator.writeFieldName("integrationResponses");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, IntegrationResponse> integrationResponsesMapValue : map.entrySet()) {
                    if (integrationResponsesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(integrationResponsesMapValue.getKey());
                    IntegrationResponseJsonMarshaller.getInstance().marshall(integrationResponsesMapValue.getValue(), jsonGenerator);
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static IntegrationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new IntegrationJsonMarshaller();
        }
        return instance;
    }
}

