/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.apigateway.model.PutMethodResponseRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.SdkHttpUtils;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Map;

public class PutMethodResponseRequestMarshaller
implements Marshaller<Request<PutMethodResponseRequest>, PutMethodResponseRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "application/x-amz-json-1.1";
    private final SdkJsonProtocolFactory protocolFactory;

    public PutMethodResponseRequestMarshaller(SdkJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<PutMethodResponseRequest> marshall(PutMethodResponseRequest putMethodResponseRequest) {
        if (putMethodResponseRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)putMethodResponseRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.PUT);
        String uriResourcePath = "/restapis/{restapi_id}/resources/{resource_id}/methods/{http_method}/responses/{status_code}";
        uriResourcePath = uriResourcePath.replace("{restapi_id}", putMethodResponseRequest.getRestApiId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodResponseRequest.getRestApiId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{resource_id}", putMethodResponseRequest.getResourceId() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodResponseRequest.getResourceId()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{http_method}", putMethodResponseRequest.getHttpMethod() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodResponseRequest.getHttpMethod()), (boolean)false) : "");
        uriResourcePath = uriResourcePath.replace("{status_code}", putMethodResponseRequest.getStatusCode() != null ? SdkHttpUtils.urlEncode((String)StringUtils.fromString((String)putMethodResponseRequest.getStatusCode()), (boolean)false) : "");
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> responseModelsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            Map<String, Boolean> responseParametersMap = putMethodResponseRequest.getResponseParameters();
            if (responseParametersMap != null) {
                jsonGenerator.writeFieldName("responseParameters");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, Boolean> responseParametersMapValue : responseParametersMap.entrySet()) {
                    if (responseParametersMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseParametersMapValue.getKey());
                    jsonGenerator.writeValue(responseParametersMapValue.getValue().booleanValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((responseModelsMap = putMethodResponseRequest.getResponseModels()) != null) {
                jsonGenerator.writeFieldName("responseModels");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> responseModelsMapValue : responseModelsMap.entrySet()) {
                    if (responseModelsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(responseModelsMapValue.getKey());
                    jsonGenerator.writeValue(responseModelsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

