/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.apigatewayv2.model.AccessLogSettings;
import com.amazonaws.services.apigatewayv2.model.RouteSettings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class UpdateStageRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private AccessLogSettings accessLogSettings;
    private String apiId;
    private String clientCertificateId;
    private RouteSettings defaultRouteSettings;
    private String deploymentId;
    private String description;
    private Map<String, RouteSettings> routeSettings;
    private String stageName;
    private Map<String, String> stageVariables;

    public void setAccessLogSettings(AccessLogSettings accessLogSettings) {
        this.accessLogSettings = accessLogSettings;
    }

    public AccessLogSettings getAccessLogSettings() {
        return this.accessLogSettings;
    }

    public UpdateStageRequest withAccessLogSettings(AccessLogSettings accessLogSettings) {
        this.setAccessLogSettings(accessLogSettings);
        return this;
    }

    public void setApiId(String apiId) {
        this.apiId = apiId;
    }

    public String getApiId() {
        return this.apiId;
    }

    public UpdateStageRequest withApiId(String apiId) {
        this.setApiId(apiId);
        return this;
    }

    public void setClientCertificateId(String clientCertificateId) {
        this.clientCertificateId = clientCertificateId;
    }

    public String getClientCertificateId() {
        return this.clientCertificateId;
    }

    public UpdateStageRequest withClientCertificateId(String clientCertificateId) {
        this.setClientCertificateId(clientCertificateId);
        return this;
    }

    public void setDefaultRouteSettings(RouteSettings defaultRouteSettings) {
        this.defaultRouteSettings = defaultRouteSettings;
    }

    public RouteSettings getDefaultRouteSettings() {
        return this.defaultRouteSettings;
    }

    public UpdateStageRequest withDefaultRouteSettings(RouteSettings defaultRouteSettings) {
        this.setDefaultRouteSettings(defaultRouteSettings);
        return this;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    public String getDeploymentId() {
        return this.deploymentId;
    }

    public UpdateStageRequest withDeploymentId(String deploymentId) {
        this.setDeploymentId(deploymentId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateStageRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, RouteSettings> getRouteSettings() {
        return this.routeSettings;
    }

    public void setRouteSettings(Map<String, RouteSettings> routeSettings) {
        this.routeSettings = routeSettings;
    }

    public UpdateStageRequest withRouteSettings(Map<String, RouteSettings> routeSettings) {
        this.setRouteSettings(routeSettings);
        return this;
    }

    public UpdateStageRequest addRouteSettingsEntry(String key, RouteSettings value) {
        if (null == this.routeSettings) {
            this.routeSettings = new HashMap<String, RouteSettings>();
        }
        if (this.routeSettings.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.routeSettings.put(key, value);
        return this;
    }

    public UpdateStageRequest clearRouteSettingsEntries() {
        this.routeSettings = null;
        return this;
    }

    public void setStageName(String stageName) {
        this.stageName = stageName;
    }

    public String getStageName() {
        return this.stageName;
    }

    public UpdateStageRequest withStageName(String stageName) {
        this.setStageName(stageName);
        return this;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public UpdateStageRequest withStageVariables(Map<String, String> stageVariables) {
        this.setStageVariables(stageVariables);
        return this;
    }

    public UpdateStageRequest addStageVariablesEntry(String key, String value) {
        if (null == this.stageVariables) {
            this.stageVariables = new HashMap<String, String>();
        }
        if (this.stageVariables.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.stageVariables.put(key, value);
        return this;
    }

    public UpdateStageRequest clearStageVariablesEntries() {
        this.stageVariables = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAccessLogSettings() != null) {
            sb.append("AccessLogSettings: ").append(this.getAccessLogSettings()).append(",");
        }
        if (this.getApiId() != null) {
            sb.append("ApiId: ").append(this.getApiId()).append(",");
        }
        if (this.getClientCertificateId() != null) {
            sb.append("ClientCertificateId: ").append(this.getClientCertificateId()).append(",");
        }
        if (this.getDefaultRouteSettings() != null) {
            sb.append("DefaultRouteSettings: ").append(this.getDefaultRouteSettings()).append(",");
        }
        if (this.getDeploymentId() != null) {
            sb.append("DeploymentId: ").append(this.getDeploymentId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getRouteSettings() != null) {
            sb.append("RouteSettings: ").append(this.getRouteSettings()).append(",");
        }
        if (this.getStageName() != null) {
            sb.append("StageName: ").append(this.getStageName()).append(",");
        }
        if (this.getStageVariables() != null) {
            sb.append("StageVariables: ").append(this.getStageVariables());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateStageRequest)) {
            return false;
        }
        UpdateStageRequest other = (UpdateStageRequest)obj;
        if (other.getAccessLogSettings() == null ^ this.getAccessLogSettings() == null) {
            return false;
        }
        if (other.getAccessLogSettings() != null && !other.getAccessLogSettings().equals(this.getAccessLogSettings())) {
            return false;
        }
        if (other.getApiId() == null ^ this.getApiId() == null) {
            return false;
        }
        if (other.getApiId() != null && !other.getApiId().equals(this.getApiId())) {
            return false;
        }
        if (other.getClientCertificateId() == null ^ this.getClientCertificateId() == null) {
            return false;
        }
        if (other.getClientCertificateId() != null && !other.getClientCertificateId().equals(this.getClientCertificateId())) {
            return false;
        }
        if (other.getDefaultRouteSettings() == null ^ this.getDefaultRouteSettings() == null) {
            return false;
        }
        if (other.getDefaultRouteSettings() != null && !other.getDefaultRouteSettings().equals(this.getDefaultRouteSettings())) {
            return false;
        }
        if (other.getDeploymentId() == null ^ this.getDeploymentId() == null) {
            return false;
        }
        if (other.getDeploymentId() != null && !other.getDeploymentId().equals(this.getDeploymentId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getRouteSettings() == null ^ this.getRouteSettings() == null) {
            return false;
        }
        if (other.getRouteSettings() != null && !other.getRouteSettings().equals(this.getRouteSettings())) {
            return false;
        }
        if (other.getStageName() == null ^ this.getStageName() == null) {
            return false;
        }
        if (other.getStageName() != null && !other.getStageName().equals(this.getStageName())) {
            return false;
        }
        if (other.getStageVariables() == null ^ this.getStageVariables() == null) {
            return false;
        }
        return other.getStageVariables() == null || other.getStageVariables().equals(this.getStageVariables());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAccessLogSettings() == null ? 0 : this.getAccessLogSettings().hashCode());
        hashCode = 31 * hashCode + (this.getApiId() == null ? 0 : this.getApiId().hashCode());
        hashCode = 31 * hashCode + (this.getClientCertificateId() == null ? 0 : this.getClientCertificateId().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultRouteSettings() == null ? 0 : this.getDefaultRouteSettings().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentId() == null ? 0 : this.getDeploymentId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getRouteSettings() == null ? 0 : this.getRouteSettings().hashCode());
        hashCode = 31 * hashCode + (this.getStageName() == null ? 0 : this.getStageName().hashCode());
        hashCode = 31 * hashCode + (this.getStageVariables() == null ? 0 : this.getStageVariables().hashCode());
        return hashCode;
    }

    public UpdateStageRequest clone() {
        return (UpdateStageRequest)super.clone();
    }
}

