/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigatewayv2.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.apigatewayv2.model.transform.JWTConfigurationMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JWTConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> audience;
    private String issuer;

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(Collection<String> audience) {
        if (audience == null) {
            this.audience = null;
            return;
        }
        this.audience = new ArrayList<String>(audience);
    }

    public JWTConfiguration withAudience(String ... audience) {
        if (this.audience == null) {
            this.setAudience(new ArrayList<String>(audience.length));
        }
        for (String ele : audience) {
            this.audience.add(ele);
        }
        return this;
    }

    public JWTConfiguration withAudience(Collection<String> audience) {
        this.setAudience(audience);
        return this;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JWTConfiguration withIssuer(String issuer) {
        this.setIssuer(issuer);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAudience() != null) {
            sb.append("Audience: ").append(this.getAudience()).append(",");
        }
        if (this.getIssuer() != null) {
            sb.append("Issuer: ").append(this.getIssuer());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JWTConfiguration)) {
            return false;
        }
        JWTConfiguration other = (JWTConfiguration)obj;
        if (other.getAudience() == null ^ this.getAudience() == null) {
            return false;
        }
        if (other.getAudience() != null && !other.getAudience().equals(this.getAudience())) {
            return false;
        }
        if (other.getIssuer() == null ^ this.getIssuer() == null) {
            return false;
        }
        return other.getIssuer() == null || other.getIssuer().equals(this.getIssuer());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAudience() == null ? 0 : this.getAudience().hashCode());
        hashCode = 31 * hashCode + (this.getIssuer() == null ? 0 : this.getIssuer().hashCode());
        return hashCode;
    }

    public JWTConfiguration clone() {
        try {
            return (JWTConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        JWTConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

