/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appfabric.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appfabric-2023-05-19/UpdateIngestionDestination"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateIngestionDestinationResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * Contains information about an ingestion destination.
     * </p>
     */
    private IngestionDestination ingestionDestination;

    /**
     * <p>
     * Contains information about an ingestion destination.
     * </p>
     * 
     * @param ingestionDestination
     *        Contains information about an ingestion destination.
     */

    public void setIngestionDestination(IngestionDestination ingestionDestination) {
        this.ingestionDestination = ingestionDestination;
    }

    /**
     * <p>
     * Contains information about an ingestion destination.
     * </p>
     * 
     * @return Contains information about an ingestion destination.
     */

    public IngestionDestination getIngestionDestination() {
        return this.ingestionDestination;
    }

    /**
     * <p>
     * Contains information about an ingestion destination.
     * </p>
     * 
     * @param ingestionDestination
     *        Contains information about an ingestion destination.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateIngestionDestinationResult withIngestionDestination(IngestionDestination ingestionDestination) {
        setIngestionDestination(ingestionDestination);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getIngestionDestination() != null)
            sb.append("IngestionDestination: ").append(getIngestionDestination());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateIngestionDestinationResult == false)
            return false;
        UpdateIngestionDestinationResult other = (UpdateIngestionDestinationResult) obj;
        if (other.getIngestionDestination() == null ^ this.getIngestionDestination() == null)
            return false;
        if (other.getIngestionDestination() != null && other.getIngestionDestination().equals(this.getIngestionDestination()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getIngestionDestination() == null) ? 0 : getIngestionDestination().hashCode());
        return hashCode;
    }

    @Override
    public UpdateIngestionDestinationResult clone() {
        try {
            return (UpdateIngestionDestinationResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
