/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appflow.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The properties that are applied when using SAPOData as a flow source.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/SAPODataSourceProperties" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class SAPODataSourceProperties implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     */
    private String objectPath;
    /**
     * <p>
     * Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * </p>
     */
    private SAPODataParallelismConfig parallelismConfig;
    /**
     * <p>
     * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * </p>
     */
    private SAPODataPaginationConfig paginationConfig;

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     * 
     * @param objectPath
     *        The object path specified in the SAPOData flow source.
     */

    public void setObjectPath(String objectPath) {
        this.objectPath = objectPath;
    }

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     * 
     * @return The object path specified in the SAPOData flow source.
     */

    public String getObjectPath() {
        return this.objectPath;
    }

    /**
     * <p>
     * The object path specified in the SAPOData flow source.
     * </p>
     * 
     * @param objectPath
     *        The object path specified in the SAPOData flow source.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SAPODataSourceProperties withObjectPath(String objectPath) {
        setObjectPath(objectPath);
        return this;
    }

    /**
     * <p>
     * Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * </p>
     * 
     * @param parallelismConfig
     *        Sets the number of concurrent processes that transfers OData records from your SAP instance.
     */

    public void setParallelismConfig(SAPODataParallelismConfig parallelismConfig) {
        this.parallelismConfig = parallelismConfig;
    }

    /**
     * <p>
     * Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * </p>
     * 
     * @return Sets the number of concurrent processes that transfers OData records from your SAP instance.
     */

    public SAPODataParallelismConfig getParallelismConfig() {
        return this.parallelismConfig;
    }

    /**
     * <p>
     * Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * </p>
     * 
     * @param parallelismConfig
     *        Sets the number of concurrent processes that transfers OData records from your SAP instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SAPODataSourceProperties withParallelismConfig(SAPODataParallelismConfig parallelismConfig) {
        setParallelismConfig(parallelismConfig);
        return this;
    }

    /**
     * <p>
     * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * </p>
     * 
     * @param paginationConfig
     *        Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     */

    public void setPaginationConfig(SAPODataPaginationConfig paginationConfig) {
        this.paginationConfig = paginationConfig;
    }

    /**
     * <p>
     * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * </p>
     * 
     * @return Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     */

    public SAPODataPaginationConfig getPaginationConfig() {
        return this.paginationConfig;
    }

    /**
     * <p>
     * Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * </p>
     * 
     * @param paginationConfig
     *        Sets the page size for each concurrent process that transfers OData records from your SAP instance.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public SAPODataSourceProperties withPaginationConfig(SAPODataPaginationConfig paginationConfig) {
        setPaginationConfig(paginationConfig);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getObjectPath() != null)
            sb.append("ObjectPath: ").append(getObjectPath()).append(",");
        if (getParallelismConfig() != null)
            sb.append("ParallelismConfig: ").append(getParallelismConfig()).append(",");
        if (getPaginationConfig() != null)
            sb.append("PaginationConfig: ").append(getPaginationConfig());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof SAPODataSourceProperties == false)
            return false;
        SAPODataSourceProperties other = (SAPODataSourceProperties) obj;
        if (other.getObjectPath() == null ^ this.getObjectPath() == null)
            return false;
        if (other.getObjectPath() != null && other.getObjectPath().equals(this.getObjectPath()) == false)
            return false;
        if (other.getParallelismConfig() == null ^ this.getParallelismConfig() == null)
            return false;
        if (other.getParallelismConfig() != null && other.getParallelismConfig().equals(this.getParallelismConfig()) == false)
            return false;
        if (other.getPaginationConfig() == null ^ this.getPaginationConfig() == null)
            return false;
        if (other.getPaginationConfig() != null && other.getPaginationConfig().equals(this.getPaginationConfig()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getObjectPath() == null) ? 0 : getObjectPath().hashCode());
        hashCode = prime * hashCode + ((getParallelismConfig() == null) ? 0 : getParallelismConfig().hashCode());
        hashCode = prime * hashCode + ((getPaginationConfig() == null) ? 0 : getPaginationConfig().hashCode());
        return hashCode;
    }

    @Override
    public SAPODataSourceProperties clone() {
        try {
            return (SAPODataSourceProperties) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.appflow.model.transform.SAPODataSourcePropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
