/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appflow.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * The connector-specific profile credentials required when using ServiceNow.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appflow-2020-08-23/ServiceNowConnectorProfileCredentials"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ServiceNowConnectorProfileCredentials implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The name of the user.
     * </p>
     */
    private String username;
    /**
     * <p>
     * The password that corresponds to the user name.
     * </p>
     */
    private String password;
    /**
     * <p>
     * The OAuth 2.0 credentials required to authenticate the user.
     * </p>
     */
    private OAuth2Credentials oAuth2Credentials;

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @param username
     *        The name of the user.
     */

    public void setUsername(String username) {
        this.username = username;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @return The name of the user.
     */

    public String getUsername() {
        return this.username;
    }

    /**
     * <p>
     * The name of the user.
     * </p>
     * 
     * @param username
     *        The name of the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowConnectorProfileCredentials withUsername(String username) {
        setUsername(username);
        return this;
    }

    /**
     * <p>
     * The password that corresponds to the user name.
     * </p>
     * 
     * @param password
     *        The password that corresponds to the user name.
     */

    public void setPassword(String password) {
        this.password = password;
    }

    /**
     * <p>
     * The password that corresponds to the user name.
     * </p>
     * 
     * @return The password that corresponds to the user name.
     */

    public String getPassword() {
        return this.password;
    }

    /**
     * <p>
     * The password that corresponds to the user name.
     * </p>
     * 
     * @param password
     *        The password that corresponds to the user name.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowConnectorProfileCredentials withPassword(String password) {
        setPassword(password);
        return this;
    }

    /**
     * <p>
     * The OAuth 2.0 credentials required to authenticate the user.
     * </p>
     * 
     * @param oAuth2Credentials
     *        The OAuth 2.0 credentials required to authenticate the user.
     */

    public void setOAuth2Credentials(OAuth2Credentials oAuth2Credentials) {
        this.oAuth2Credentials = oAuth2Credentials;
    }

    /**
     * <p>
     * The OAuth 2.0 credentials required to authenticate the user.
     * </p>
     * 
     * @return The OAuth 2.0 credentials required to authenticate the user.
     */

    public OAuth2Credentials getOAuth2Credentials() {
        return this.oAuth2Credentials;
    }

    /**
     * <p>
     * The OAuth 2.0 credentials required to authenticate the user.
     * </p>
     * 
     * @param oAuth2Credentials
     *        The OAuth 2.0 credentials required to authenticate the user.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ServiceNowConnectorProfileCredentials withOAuth2Credentials(OAuth2Credentials oAuth2Credentials) {
        setOAuth2Credentials(oAuth2Credentials);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getUsername() != null)
            sb.append("Username: ").append(getUsername()).append(",");
        if (getPassword() != null)
            sb.append("Password: ").append("***Sensitive Data Redacted***").append(",");
        if (getOAuth2Credentials() != null)
            sb.append("OAuth2Credentials: ").append(getOAuth2Credentials());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ServiceNowConnectorProfileCredentials == false)
            return false;
        ServiceNowConnectorProfileCredentials other = (ServiceNowConnectorProfileCredentials) obj;
        if (other.getUsername() == null ^ this.getUsername() == null)
            return false;
        if (other.getUsername() != null && other.getUsername().equals(this.getUsername()) == false)
            return false;
        if (other.getPassword() == null ^ this.getPassword() == null)
            return false;
        if (other.getPassword() != null && other.getPassword().equals(this.getPassword()) == false)
            return false;
        if (other.getOAuth2Credentials() == null ^ this.getOAuth2Credentials() == null)
            return false;
        if (other.getOAuth2Credentials() != null && other.getOAuth2Credentials().equals(this.getOAuth2Credentials()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getUsername() == null) ? 0 : getUsername().hashCode());
        hashCode = prime * hashCode + ((getPassword() == null) ? 0 : getPassword().hashCode());
        hashCode = prime * hashCode + ((getOAuth2Credentials() == null) ? 0 : getOAuth2Credentials().hashCode());
        return hashCode;
    }

    @Override
    public ServiceNowConnectorProfileCredentials clone() {
        try {
            return (ServiceNowConnectorProfileCredentials) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.appflow.model.transform.ServiceNowConnectorProfileCredentialsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
