/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.applicationsignals.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/application-signals-2024-04-15/UpdateServiceLevelObjective"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class UpdateServiceLevelObjectiveResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A structure that contains information about the SLO that you just updated.
     * </p>
     */
    private ServiceLevelObjective slo;

    /**
     * <p>
     * A structure that contains information about the SLO that you just updated.
     * </p>
     * 
     * @param slo
     *        A structure that contains information about the SLO that you just updated.
     */

    public void setSlo(ServiceLevelObjective slo) {
        this.slo = slo;
    }

    /**
     * <p>
     * A structure that contains information about the SLO that you just updated.
     * </p>
     * 
     * @return A structure that contains information about the SLO that you just updated.
     */

    public ServiceLevelObjective getSlo() {
        return this.slo;
    }

    /**
     * <p>
     * A structure that contains information about the SLO that you just updated.
     * </p>
     * 
     * @param slo
     *        A structure that contains information about the SLO that you just updated.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public UpdateServiceLevelObjectiveResult withSlo(ServiceLevelObjective slo) {
        setSlo(slo);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSlo() != null)
            sb.append("Slo: ").append(getSlo());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof UpdateServiceLevelObjectiveResult == false)
            return false;
        UpdateServiceLevelObjectiveResult other = (UpdateServiceLevelObjectiveResult) obj;
        if (other.getSlo() == null ^ this.getSlo() == null)
            return false;
        if (other.getSlo() != null && other.getSlo().equals(this.getSlo()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSlo() == null) ? 0 : getSlo().hashCode());
        return hashCode;
    }

    @Override
    public UpdateServiceLevelObjectiveResult clone() {
        try {
            return (UpdateServiceLevelObjectiveResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
