/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

/**
 * <important>
 * <p>
 * This is a Preview release of the Application Signals API Reference. Operations and parameters are subject to change
 * before the general availability release.
 * </p>
 * </important>
 * <p>
 * Use CloudWatch Application Signals for comprehensive observability of your cloud-based applications. It enables
 * real-time service health dashboards and helps you track long-term performance trends against your business goals. The
 * application-centric view provides you with unified visibility across your applications, services, and dependencies,
 * so you can proactively monitor and efficiently triage any issues that may arise, ensuring optimal customer
 * experience.
 * </p>
 * <p>
 * Application Signals provides the following benefits:
 * </p>
 * <ul>
 * <li>
 * <p>
 * Automatically collect metrics and traces from your applications, and display key metrics such as call volume,
 * availability, latency, faults, and errors.
 * </p>
 * </li>
 * <li>
 * <p>
 * Create and monitor service level objectives (SLOs).
 * </p>
 * </li>
 * <li>
 * <p>
 * See a map of your application topology that Application Signals automatically discovers, that gives you a visual
 * representation of your applications, dependencies, and their connectivity.
 * </p>
 * </li>
 * </ul>
 */
package com.amazonaws.services.applicationsignals;

