/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.appstream.AmazonAppStreamAsync;
import com.amazonaws.services.appstream.AmazonAppStreamAsyncClientBuilder;
import com.amazonaws.services.appstream.AmazonAppStreamClient;
import com.amazonaws.services.appstream.model.AssociateFleetRequest;
import com.amazonaws.services.appstream.model.AssociateFleetResult;
import com.amazonaws.services.appstream.model.CreateFleetRequest;
import com.amazonaws.services.appstream.model.CreateFleetResult;
import com.amazonaws.services.appstream.model.CreateStackRequest;
import com.amazonaws.services.appstream.model.CreateStackResult;
import com.amazonaws.services.appstream.model.CreateStreamingURLRequest;
import com.amazonaws.services.appstream.model.CreateStreamingURLResult;
import com.amazonaws.services.appstream.model.DeleteFleetRequest;
import com.amazonaws.services.appstream.model.DeleteFleetResult;
import com.amazonaws.services.appstream.model.DeleteStackRequest;
import com.amazonaws.services.appstream.model.DeleteStackResult;
import com.amazonaws.services.appstream.model.DescribeFleetsRequest;
import com.amazonaws.services.appstream.model.DescribeFleetsResult;
import com.amazonaws.services.appstream.model.DescribeImagesRequest;
import com.amazonaws.services.appstream.model.DescribeImagesResult;
import com.amazonaws.services.appstream.model.DescribeSessionsRequest;
import com.amazonaws.services.appstream.model.DescribeSessionsResult;
import com.amazonaws.services.appstream.model.DescribeStacksRequest;
import com.amazonaws.services.appstream.model.DescribeStacksResult;
import com.amazonaws.services.appstream.model.DisassociateFleetRequest;
import com.amazonaws.services.appstream.model.DisassociateFleetResult;
import com.amazonaws.services.appstream.model.ExpireSessionRequest;
import com.amazonaws.services.appstream.model.ExpireSessionResult;
import com.amazonaws.services.appstream.model.ListAssociatedFleetsRequest;
import com.amazonaws.services.appstream.model.ListAssociatedFleetsResult;
import com.amazonaws.services.appstream.model.ListAssociatedStacksRequest;
import com.amazonaws.services.appstream.model.ListAssociatedStacksResult;
import com.amazonaws.services.appstream.model.StartFleetRequest;
import com.amazonaws.services.appstream.model.StartFleetResult;
import com.amazonaws.services.appstream.model.StopFleetRequest;
import com.amazonaws.services.appstream.model.StopFleetResult;
import com.amazonaws.services.appstream.model.UpdateFleetRequest;
import com.amazonaws.services.appstream.model.UpdateFleetResult;
import com.amazonaws.services.appstream.model.UpdateStackRequest;
import com.amazonaws.services.appstream.model.UpdateStackResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAppStreamAsyncClient
extends AmazonAppStreamClient
implements AmazonAppStreamAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonAppStreamAsyncClient() {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonAppStreamAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public static AmazonAppStreamAsyncClientBuilder asyncBuilder() {
        return AmazonAppStreamAsyncClientBuilder.standard();
    }

    AmazonAppStreamAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AssociateFleetResult> associateFleetAsync(AssociateFleetRequest request) {
        return this.associateFleetAsync(request, null);
    }

    @Override
    public Future<AssociateFleetResult> associateFleetAsync(AssociateFleetRequest request, final AsyncHandler<AssociateFleetRequest, AssociateFleetResult> asyncHandler) {
        final AssociateFleetRequest finalRequest = (AssociateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<AssociateFleetResult>(){

            @Override
            public AssociateFleetResult call() throws Exception {
                AssociateFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeAssociateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request) {
        return this.createFleetAsync(request, null);
    }

    @Override
    public Future<CreateFleetResult> createFleetAsync(CreateFleetRequest request, final AsyncHandler<CreateFleetRequest, CreateFleetResult> asyncHandler) {
        final CreateFleetRequest finalRequest = (CreateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateFleetResult>(){

            @Override
            public CreateFleetResult call() throws Exception {
                CreateFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeCreateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStackResult> createStackAsync(CreateStackRequest request) {
        return this.createStackAsync(request, null);
    }

    @Override
    public Future<CreateStackResult> createStackAsync(CreateStackRequest request, final AsyncHandler<CreateStackRequest, CreateStackResult> asyncHandler) {
        final CreateStackRequest finalRequest = (CreateStackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStackResult>(){

            @Override
            public CreateStackResult call() throws Exception {
                CreateStackResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeCreateStack(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateStreamingURLResult> createStreamingURLAsync(CreateStreamingURLRequest request) {
        return this.createStreamingURLAsync(request, null);
    }

    @Override
    public Future<CreateStreamingURLResult> createStreamingURLAsync(CreateStreamingURLRequest request, final AsyncHandler<CreateStreamingURLRequest, CreateStreamingURLResult> asyncHandler) {
        final CreateStreamingURLRequest finalRequest = (CreateStreamingURLRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<CreateStreamingURLResult>(){

            @Override
            public CreateStreamingURLResult call() throws Exception {
                CreateStreamingURLResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeCreateStreamingURL(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request) {
        return this.deleteFleetAsync(request, null);
    }

    @Override
    public Future<DeleteFleetResult> deleteFleetAsync(DeleteFleetRequest request, final AsyncHandler<DeleteFleetRequest, DeleteFleetResult> asyncHandler) {
        final DeleteFleetRequest finalRequest = (DeleteFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteFleetResult>(){

            @Override
            public DeleteFleetResult call() throws Exception {
                DeleteFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDeleteFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteStackResult> deleteStackAsync(DeleteStackRequest request) {
        return this.deleteStackAsync(request, null);
    }

    @Override
    public Future<DeleteStackResult> deleteStackAsync(DeleteStackRequest request, final AsyncHandler<DeleteStackRequest, DeleteStackResult> asyncHandler) {
        final DeleteStackRequest finalRequest = (DeleteStackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteStackResult>(){

            @Override
            public DeleteStackResult call() throws Exception {
                DeleteStackResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDeleteStack(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeFleetsResult> describeFleetsAsync(DescribeFleetsRequest request) {
        return this.describeFleetsAsync(request, null);
    }

    @Override
    public Future<DescribeFleetsResult> describeFleetsAsync(DescribeFleetsRequest request, final AsyncHandler<DescribeFleetsRequest, DescribeFleetsResult> asyncHandler) {
        final DescribeFleetsRequest finalRequest = (DescribeFleetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeFleetsResult>(){

            @Override
            public DescribeFleetsResult call() throws Exception {
                DescribeFleetsResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDescribeFleets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request) {
        return this.describeImagesAsync(request, null);
    }

    @Override
    public Future<DescribeImagesResult> describeImagesAsync(DescribeImagesRequest request, final AsyncHandler<DescribeImagesRequest, DescribeImagesResult> asyncHandler) {
        final DescribeImagesRequest finalRequest = (DescribeImagesRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeImagesResult>(){

            @Override
            public DescribeImagesResult call() throws Exception {
                DescribeImagesResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDescribeImages(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeSessionsResult> describeSessionsAsync(DescribeSessionsRequest request) {
        return this.describeSessionsAsync(request, null);
    }

    @Override
    public Future<DescribeSessionsResult> describeSessionsAsync(DescribeSessionsRequest request, final AsyncHandler<DescribeSessionsRequest, DescribeSessionsResult> asyncHandler) {
        final DescribeSessionsRequest finalRequest = (DescribeSessionsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeSessionsResult>(){

            @Override
            public DescribeSessionsResult call() throws Exception {
                DescribeSessionsResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDescribeSessions(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(DescribeStacksRequest request) {
        return this.describeStacksAsync(request, null);
    }

    @Override
    public Future<DescribeStacksResult> describeStacksAsync(DescribeStacksRequest request, final AsyncHandler<DescribeStacksRequest, DescribeStacksResult> asyncHandler) {
        final DescribeStacksRequest finalRequest = (DescribeStacksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeStacksResult>(){

            @Override
            public DescribeStacksResult call() throws Exception {
                DescribeStacksResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDescribeStacks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DisassociateFleetResult> disassociateFleetAsync(DisassociateFleetRequest request) {
        return this.disassociateFleetAsync(request, null);
    }

    @Override
    public Future<DisassociateFleetResult> disassociateFleetAsync(DisassociateFleetRequest request, final AsyncHandler<DisassociateFleetRequest, DisassociateFleetResult> asyncHandler) {
        final DisassociateFleetRequest finalRequest = (DisassociateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DisassociateFleetResult>(){

            @Override
            public DisassociateFleetResult call() throws Exception {
                DisassociateFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeDisassociateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ExpireSessionResult> expireSessionAsync(ExpireSessionRequest request) {
        return this.expireSessionAsync(request, null);
    }

    @Override
    public Future<ExpireSessionResult> expireSessionAsync(ExpireSessionRequest request, final AsyncHandler<ExpireSessionRequest, ExpireSessionResult> asyncHandler) {
        final ExpireSessionRequest finalRequest = (ExpireSessionRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ExpireSessionResult>(){

            @Override
            public ExpireSessionResult call() throws Exception {
                ExpireSessionResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeExpireSession(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociatedFleetsResult> listAssociatedFleetsAsync(ListAssociatedFleetsRequest request) {
        return this.listAssociatedFleetsAsync(request, null);
    }

    @Override
    public Future<ListAssociatedFleetsResult> listAssociatedFleetsAsync(ListAssociatedFleetsRequest request, final AsyncHandler<ListAssociatedFleetsRequest, ListAssociatedFleetsResult> asyncHandler) {
        final ListAssociatedFleetsRequest finalRequest = (ListAssociatedFleetsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociatedFleetsResult>(){

            @Override
            public ListAssociatedFleetsResult call() throws Exception {
                ListAssociatedFleetsResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeListAssociatedFleets(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListAssociatedStacksResult> listAssociatedStacksAsync(ListAssociatedStacksRequest request) {
        return this.listAssociatedStacksAsync(request, null);
    }

    @Override
    public Future<ListAssociatedStacksResult> listAssociatedStacksAsync(ListAssociatedStacksRequest request, final AsyncHandler<ListAssociatedStacksRequest, ListAssociatedStacksResult> asyncHandler) {
        final ListAssociatedStacksRequest finalRequest = (ListAssociatedStacksRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListAssociatedStacksResult>(){

            @Override
            public ListAssociatedStacksResult call() throws Exception {
                ListAssociatedStacksResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeListAssociatedStacks(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartFleetResult> startFleetAsync(StartFleetRequest request) {
        return this.startFleetAsync(request, null);
    }

    @Override
    public Future<StartFleetResult> startFleetAsync(StartFleetRequest request, final AsyncHandler<StartFleetRequest, StartFleetResult> asyncHandler) {
        final StartFleetRequest finalRequest = (StartFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartFleetResult>(){

            @Override
            public StartFleetResult call() throws Exception {
                StartFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeStartFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopFleetResult> stopFleetAsync(StopFleetRequest request) {
        return this.stopFleetAsync(request, null);
    }

    @Override
    public Future<StopFleetResult> stopFleetAsync(StopFleetRequest request, final AsyncHandler<StopFleetRequest, StopFleetResult> asyncHandler) {
        final StopFleetRequest finalRequest = (StopFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopFleetResult>(){

            @Override
            public StopFleetResult call() throws Exception {
                StopFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeStopFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request) {
        return this.updateFleetAsync(request, null);
    }

    @Override
    public Future<UpdateFleetResult> updateFleetAsync(UpdateFleetRequest request, final AsyncHandler<UpdateFleetRequest, UpdateFleetResult> asyncHandler) {
        final UpdateFleetRequest finalRequest = (UpdateFleetRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateFleetResult>(){

            @Override
            public UpdateFleetResult call() throws Exception {
                UpdateFleetResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeUpdateFleet(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(UpdateStackRequest request) {
        return this.updateStackAsync(request, null);
    }

    @Override
    public Future<UpdateStackResult> updateStackAsync(UpdateStackRequest request, final AsyncHandler<UpdateStackRequest, UpdateStackResult> asyncHandler) {
        final UpdateStackRequest finalRequest = (UpdateStackRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<UpdateStackResult>(){

            @Override
            public UpdateStackResult call() throws Exception {
                UpdateStackResult result = null;
                try {
                    result = AmazonAppStreamAsyncClient.this.executeUpdateStack(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

