/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.appstream.waiters;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.services.appstream.AmazonAppStream;
import com.amazonaws.services.appstream.model.DescribeFleetsRequest;
import com.amazonaws.services.appstream.waiters.DescribeFleetsFunction;
import com.amazonaws.services.appstream.waiters.FleetStarted;
import com.amazonaws.services.appstream.waiters.FleetStopped;
import com.amazonaws.waiters.FixedDelayStrategy;
import com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import com.amazonaws.waiters.PollingStrategy;
import com.amazonaws.waiters.SdkFunction;
import com.amazonaws.waiters.Waiter;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterBuilder;
import com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonAppStreamWaiters {
    private final AmazonAppStream client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter((String)"AmazonAppStreamWaiters");

    @SdkInternalApi
    public AmazonAppStreamWaiters(AmazonAppStream client) {
        this.client = client;
    }

    public Waiter<DescribeFleetsRequest> fleetStarted() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFleetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FleetStarted.IsACTIVEMatcher(), new FleetStarted.IsPENDING_DEACTIVATEMatcher(), new FleetStarted.IsINACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeFleetsRequest> fleetStopped() {
        return new WaiterBuilder().withSdkFunction((SdkFunction)new DescribeFleetsFunction(this.client)).withAcceptors(new WaiterAcceptor[]{new FleetStopped.IsINACTIVEMatcher(), new FleetStopped.IsPENDING_ACTIVATEMatcher(), new FleetStopped.IsACTIVEMatcher()}).withDefaultPollingStrategy(new PollingStrategy((PollingStrategy.RetryStrategy)new MaxAttemptsRetryStrategy(40), (PollingStrategy.DelayStrategy)new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

