/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateSourceGraphqlApi"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DisassociateSourceGraphqlApiResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The state of the source API association.
     * </p>
     */
    private String sourceApiAssociationStatus;

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * 
     * @param sourceApiAssociationStatus
     *        The state of the source API association.
     * @see SourceApiAssociationStatus
     */

    public void setSourceApiAssociationStatus(String sourceApiAssociationStatus) {
        this.sourceApiAssociationStatus = sourceApiAssociationStatus;
    }

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * 
     * @return The state of the source API association.
     * @see SourceApiAssociationStatus
     */

    public String getSourceApiAssociationStatus() {
        return this.sourceApiAssociationStatus;
    }

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * 
     * @param sourceApiAssociationStatus
     *        The state of the source API association.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SourceApiAssociationStatus
     */

    public DisassociateSourceGraphqlApiResult withSourceApiAssociationStatus(String sourceApiAssociationStatus) {
        setSourceApiAssociationStatus(sourceApiAssociationStatus);
        return this;
    }

    /**
     * <p>
     * The state of the source API association.
     * </p>
     * 
     * @param sourceApiAssociationStatus
     *        The state of the source API association.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see SourceApiAssociationStatus
     */

    public DisassociateSourceGraphqlApiResult withSourceApiAssociationStatus(SourceApiAssociationStatus sourceApiAssociationStatus) {
        this.sourceApiAssociationStatus = sourceApiAssociationStatus.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSourceApiAssociationStatus() != null)
            sb.append("SourceApiAssociationStatus: ").append(getSourceApiAssociationStatus());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DisassociateSourceGraphqlApiResult == false)
            return false;
        DisassociateSourceGraphqlApiResult other = (DisassociateSourceGraphqlApiResult) obj;
        if (other.getSourceApiAssociationStatus() == null ^ this.getSourceApiAssociationStatus() == null)
            return false;
        if (other.getSourceApiAssociationStatus() != null && other.getSourceApiAssociationStatus().equals(this.getSourceApiAssociationStatus()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSourceApiAssociationStatus() == null) ? 0 : getSourceApiAssociationStatus().hashCode());
        return hashCode;
    }

    @Override
    public DisassociateSourceGraphqlApiResult clone() {
        try {
            return (DisassociateSourceGraphqlApiResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
