/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateCode" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class EvaluateCodeResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The result of the evaluation operation.
     * </p>
     */
    private String evaluationResult;
    /**
     * <p>
     * Contains the payload of the response error.
     * </p>
     */
    private EvaluateCodeErrorDetail error;
    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     */
    private java.util.List<String> logs;

    /**
     * <p>
     * The result of the evaluation operation.
     * </p>
     * 
     * @param evaluationResult
     *        The result of the evaluation operation.
     */

    public void setEvaluationResult(String evaluationResult) {
        this.evaluationResult = evaluationResult;
    }

    /**
     * <p>
     * The result of the evaluation operation.
     * </p>
     * 
     * @return The result of the evaluation operation.
     */

    public String getEvaluationResult() {
        return this.evaluationResult;
    }

    /**
     * <p>
     * The result of the evaluation operation.
     * </p>
     * 
     * @param evaluationResult
     *        The result of the evaluation operation.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EvaluateCodeResult withEvaluationResult(String evaluationResult) {
        setEvaluationResult(evaluationResult);
        return this;
    }

    /**
     * <p>
     * Contains the payload of the response error.
     * </p>
     * 
     * @param error
     *        Contains the payload of the response error.
     */

    public void setError(EvaluateCodeErrorDetail error) {
        this.error = error;
    }

    /**
     * <p>
     * Contains the payload of the response error.
     * </p>
     * 
     * @return Contains the payload of the response error.
     */

    public EvaluateCodeErrorDetail getError() {
        return this.error;
    }

    /**
     * <p>
     * Contains the payload of the response error.
     * </p>
     * 
     * @param error
     *        Contains the payload of the response error.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EvaluateCodeResult withError(EvaluateCodeErrorDetail error) {
        setError(error);
        return this;
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * 
     * @return A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *         in the evaluated code.
     */

    public java.util.List<String> getLogs() {
        return logs;
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * 
     * @param logs
     *        A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *        in the evaluated code.
     */

    public void setLogs(java.util.Collection<String> logs) {
        if (logs == null) {
            this.logs = null;
            return;
        }

        this.logs = new java.util.ArrayList<String>(logs);
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setLogs(java.util.Collection)} or {@link #withLogs(java.util.Collection)} if you want to override the
     * existing values.
     * </p>
     * 
     * @param logs
     *        A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *        in the evaluated code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EvaluateCodeResult withLogs(String... logs) {
        if (this.logs == null) {
            setLogs(new java.util.ArrayList<String>(logs.length));
        }
        for (String ele : logs) {
            this.logs.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code> in the
     * evaluated code.
     * </p>
     * 
     * @param logs
     *        A list of logs that were generated by calls to <code>util.log.info</code> and <code>util.log.error</code>
     *        in the evaluated code.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public EvaluateCodeResult withLogs(java.util.Collection<String> logs) {
        setLogs(logs);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getEvaluationResult() != null)
            sb.append("EvaluationResult: ").append(getEvaluationResult()).append(",");
        if (getError() != null)
            sb.append("Error: ").append(getError()).append(",");
        if (getLogs() != null)
            sb.append("Logs: ").append(getLogs());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof EvaluateCodeResult == false)
            return false;
        EvaluateCodeResult other = (EvaluateCodeResult) obj;
        if (other.getEvaluationResult() == null ^ this.getEvaluationResult() == null)
            return false;
        if (other.getEvaluationResult() != null && other.getEvaluationResult().equals(this.getEvaluationResult()) == false)
            return false;
        if (other.getError() == null ^ this.getError() == null)
            return false;
        if (other.getError() != null && other.getError().equals(this.getError()) == false)
            return false;
        if (other.getLogs() == null ^ this.getLogs() == null)
            return false;
        if (other.getLogs() != null && other.getLogs().equals(this.getLogs()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getEvaluationResult() == null) ? 0 : getEvaluationResult().hashCode());
        hashCode = prime * hashCode + ((getError() == null) ? 0 : getError().hashCode());
        hashCode = prime * hashCode + ((getLogs() == null) ? 0 : getLogs().hashCode());
        return hashCode;
    }

    @Override
    public EvaluateCodeResult clone() {
        try {
            return (EvaluateCodeResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
