/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.appsync.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateMergedGraphqlApi" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssociateMergedGraphqlApiRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     */
    private String sourceApiIdentifier;
    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     */
    private String mergedApiIdentifier;
    /**
     * <p>
     * The description field.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The <code>SourceApiAssociationConfig</code> object data.
     * </p>
     */
    private SourceApiAssociationConfig sourceApiAssociationConfig;

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @param sourceApiIdentifier
     *        The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *        APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *        APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *        API.
     */

    public void setSourceApiIdentifier(String sourceApiIdentifier) {
        this.sourceApiIdentifier = sourceApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @return The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *         APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *         APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *         API.
     */

    public String getSourceApiIdentifier() {
        return this.sourceApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @param sourceApiIdentifier
     *        The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *        APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *        APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *        API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateMergedGraphqlApiRequest withSourceApiIdentifier(String sourceApiIdentifier) {
        setSourceApiIdentifier(sourceApiIdentifier);
        return this;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @param mergedApiIdentifier
     *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *        APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *        APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     */

    public void setMergedApiIdentifier(String mergedApiIdentifier) {
        this.mergedApiIdentifier = mergedApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @return The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *         APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *         APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged
     *         API.
     */

    public String getMergedApiIdentifier() {
        return this.mergedApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @param mergedApiIdentifier
     *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *        APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *        APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateMergedGraphqlApiRequest withMergedApiIdentifier(String mergedApiIdentifier) {
        setMergedApiIdentifier(mergedApiIdentifier);
        return this;
    }

    /**
     * <p>
     * The description field.
     * </p>
     * 
     * @param description
     *        The description field.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description field.
     * </p>
     * 
     * @return The description field.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description field.
     * </p>
     * 
     * @param description
     *        The description field.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateMergedGraphqlApiRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The <code>SourceApiAssociationConfig</code> object data.
     * </p>
     * 
     * @param sourceApiAssociationConfig
     *        The <code>SourceApiAssociationConfig</code> object data.
     */

    public void setSourceApiAssociationConfig(SourceApiAssociationConfig sourceApiAssociationConfig) {
        this.sourceApiAssociationConfig = sourceApiAssociationConfig;
    }

    /**
     * <p>
     * The <code>SourceApiAssociationConfig</code> object data.
     * </p>
     * 
     * @return The <code>SourceApiAssociationConfig</code> object data.
     */

    public SourceApiAssociationConfig getSourceApiAssociationConfig() {
        return this.sourceApiAssociationConfig;
    }

    /**
     * <p>
     * The <code>SourceApiAssociationConfig</code> object data.
     * </p>
     * 
     * @param sourceApiAssociationConfig
     *        The <code>SourceApiAssociationConfig</code> object data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssociateMergedGraphqlApiRequest withSourceApiAssociationConfig(SourceApiAssociationConfig sourceApiAssociationConfig) {
        setSourceApiAssociationConfig(sourceApiAssociationConfig);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSourceApiIdentifier() != null)
            sb.append("SourceApiIdentifier: ").append(getSourceApiIdentifier()).append(",");
        if (getMergedApiIdentifier() != null)
            sb.append("MergedApiIdentifier: ").append(getMergedApiIdentifier()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getSourceApiAssociationConfig() != null)
            sb.append("SourceApiAssociationConfig: ").append(getSourceApiAssociationConfig());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AssociateMergedGraphqlApiRequest == false)
            return false;
        AssociateMergedGraphqlApiRequest other = (AssociateMergedGraphqlApiRequest) obj;
        if (other.getSourceApiIdentifier() == null ^ this.getSourceApiIdentifier() == null)
            return false;
        if (other.getSourceApiIdentifier() != null && other.getSourceApiIdentifier().equals(this.getSourceApiIdentifier()) == false)
            return false;
        if (other.getMergedApiIdentifier() == null ^ this.getMergedApiIdentifier() == null)
            return false;
        if (other.getMergedApiIdentifier() != null && other.getMergedApiIdentifier().equals(this.getMergedApiIdentifier()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getSourceApiAssociationConfig() == null ^ this.getSourceApiAssociationConfig() == null)
            return false;
        if (other.getSourceApiAssociationConfig() != null && other.getSourceApiAssociationConfig().equals(this.getSourceApiAssociationConfig()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSourceApiIdentifier() == null) ? 0 : getSourceApiIdentifier().hashCode());
        hashCode = prime * hashCode + ((getMergedApiIdentifier() == null) ? 0 : getMergedApiIdentifier().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getSourceApiAssociationConfig() == null) ? 0 : getSourceApiAssociationConfig().hashCode());
        return hashCode;
    }

    @Override
    public AssociateMergedGraphqlApiRequest clone() {
        return (AssociateMergedGraphqlApiRequest) super.clone();
    }

}
