/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.apptest.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Specifies test cases.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/TestCases" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TestCases implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The sequential of the test case.
     * </p>
     */
    private java.util.List<String> sequential;

    /**
     * <p>
     * The sequential of the test case.
     * </p>
     * 
     * @return The sequential of the test case.
     */

    public java.util.List<String> getSequential() {
        return sequential;
    }

    /**
     * <p>
     * The sequential of the test case.
     * </p>
     * 
     * @param sequential
     *        The sequential of the test case.
     */

    public void setSequential(java.util.Collection<String> sequential) {
        if (sequential == null) {
            this.sequential = null;
            return;
        }

        this.sequential = new java.util.ArrayList<String>(sequential);
    }

    /**
     * <p>
     * The sequential of the test case.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSequential(java.util.Collection)} or {@link #withSequential(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param sequential
     *        The sequential of the test case.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TestCases withSequential(String... sequential) {
        if (this.sequential == null) {
            setSequential(new java.util.ArrayList<String>(sequential.length));
        }
        for (String ele : sequential) {
            this.sequential.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The sequential of the test case.
     * </p>
     * 
     * @param sequential
     *        The sequential of the test case.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TestCases withSequential(java.util.Collection<String> sequential) {
        setSequential(sequential);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSequential() != null)
            sb.append("Sequential: ").append(getSequential());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TestCases == false)
            return false;
        TestCases other = (TestCases) obj;
        if (other.getSequential() == null ^ this.getSequential() == null)
            return false;
        if (other.getSequential() != null && other.getSequential().equals(this.getSequential()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSequential() == null) ? 0 : getSequential().hashCode());
        return hashCode;
    }

    @Override
    public TestCases clone() {
        try {
            return (TestCases) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.apptest.model.transform.TestCasesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
