/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.artifact;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.artifact.AWSArtifactAsync;
import com.amazonaws.services.artifact.AWSArtifactAsyncClientBuilder;
import com.amazonaws.services.artifact.AWSArtifactClient;
import com.amazonaws.services.artifact.model.GetAccountSettingsRequest;
import com.amazonaws.services.artifact.model.GetAccountSettingsResult;
import com.amazonaws.services.artifact.model.GetReportMetadataRequest;
import com.amazonaws.services.artifact.model.GetReportMetadataResult;
import com.amazonaws.services.artifact.model.GetReportRequest;
import com.amazonaws.services.artifact.model.GetReportResult;
import com.amazonaws.services.artifact.model.GetTermForReportRequest;
import com.amazonaws.services.artifact.model.GetTermForReportResult;
import com.amazonaws.services.artifact.model.ListReportsRequest;
import com.amazonaws.services.artifact.model.ListReportsResult;
import com.amazonaws.services.artifact.model.PutAccountSettingsRequest;
import com.amazonaws.services.artifact.model.PutAccountSettingsResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AWSArtifactAsyncClient
extends AWSArtifactClient
implements AWSArtifactAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AWSArtifactAsyncClientBuilder asyncBuilder() {
        return AWSArtifactAsyncClientBuilder.standard();
    }

    AWSArtifactAsyncClient(AwsAsyncClientParams asyncClientParams) {
        this(asyncClientParams, false);
    }

    AWSArtifactAsyncClient(AwsAsyncClientParams asyncClientParams, boolean endpointDiscoveryEnabled) {
        super((AwsSyncClientParams)asyncClientParams, endpointDiscoveryEnabled);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request) {
        return this.getAccountSettingsAsync(request, null);
    }

    @Override
    public Future<GetAccountSettingsResult> getAccountSettingsAsync(GetAccountSettingsRequest request, final AsyncHandler<GetAccountSettingsRequest, GetAccountSettingsResult> asyncHandler) {
        final GetAccountSettingsRequest finalRequest = (GetAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetAccountSettingsResult>(){

            @Override
            public GetAccountSettingsResult call() throws Exception {
                GetAccountSettingsResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executeGetAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReportResult> getReportAsync(GetReportRequest request) {
        return this.getReportAsync(request, null);
    }

    @Override
    public Future<GetReportResult> getReportAsync(GetReportRequest request, final AsyncHandler<GetReportRequest, GetReportResult> asyncHandler) {
        final GetReportRequest finalRequest = (GetReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReportResult>(){

            @Override
            public GetReportResult call() throws Exception {
                GetReportResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executeGetReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetReportMetadataResult> getReportMetadataAsync(GetReportMetadataRequest request) {
        return this.getReportMetadataAsync(request, null);
    }

    @Override
    public Future<GetReportMetadataResult> getReportMetadataAsync(GetReportMetadataRequest request, final AsyncHandler<GetReportMetadataRequest, GetReportMetadataResult> asyncHandler) {
        final GetReportMetadataRequest finalRequest = (GetReportMetadataRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetReportMetadataResult>(){

            @Override
            public GetReportMetadataResult call() throws Exception {
                GetReportMetadataResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executeGetReportMetadata(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetTermForReportResult> getTermForReportAsync(GetTermForReportRequest request) {
        return this.getTermForReportAsync(request, null);
    }

    @Override
    public Future<GetTermForReportResult> getTermForReportAsync(GetTermForReportRequest request, final AsyncHandler<GetTermForReportRequest, GetTermForReportResult> asyncHandler) {
        final GetTermForReportRequest finalRequest = (GetTermForReportRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<GetTermForReportResult>(){

            @Override
            public GetTermForReportResult call() throws Exception {
                GetTermForReportResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executeGetTermForReport(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListReportsResult> listReportsAsync(ListReportsRequest request) {
        return this.listReportsAsync(request, null);
    }

    @Override
    public Future<ListReportsResult> listReportsAsync(ListReportsRequest request, final AsyncHandler<ListReportsRequest, ListReportsResult> asyncHandler) {
        final ListReportsRequest finalRequest = (ListReportsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListReportsResult>(){

            @Override
            public ListReportsResult call() throws Exception {
                ListReportsResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executeListReports(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutAccountSettingsResult> putAccountSettingsAsync(PutAccountSettingsRequest request) {
        return this.putAccountSettingsAsync(request, null);
    }

    @Override
    public Future<PutAccountSettingsResult> putAccountSettingsAsync(PutAccountSettingsRequest request, final AsyncHandler<PutAccountSettingsRequest, PutAccountSettingsResult> asyncHandler) {
        final PutAccountSettingsRequest finalRequest = (PutAccountSettingsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<PutAccountSettingsResult>(){

            @Override
            public PutAccountSettingsResult call() throws Exception {
                PutAccountSettingsResult result = null;
                try {
                    result = AWSArtifactAsyncClient.this.executePutAccountSettings(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

