/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.Column;

@SdkInternalApi
public class ColumnMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Name").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> COMMENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Comment").build();
    private static final ColumnMarshaller instance = new ColumnMarshaller();

    public static ColumnMarshaller getInstance() {
        return instance;
    }

    public void marshall(Column column, ProtocolMarshaller protocolMarshaller) {
        if (column == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)column.getName(), NAME_BINDING);
            protocolMarshaller.marshall((Object)column.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)column.getComment(), COMMENT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

