/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListCalculationExecutionsRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The session ID.
     * </p>
     */
    private String sessionId;
    /**
     * <p>
     * A filter for a specific calculation execution state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     */
    private String stateFilter;
    /**
     * <p>
     * The maximum number of calculation executions to return.
     * </p>
     */
    private Integer maxResults;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @param sessionId
     *        The session ID.
     */

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */

    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @param sessionId
     *        The session ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsRequest withSessionId(String sessionId) {
        setSessionId(sessionId);
        return this;
    }

    /**
     * <p>
     * A filter for a specific calculation execution state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific calculation execution state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The calculation is in the process of being created.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The calculation has been created and is ready to run.
     *        </p>
     *        <p>
     *        <code>QUEUED</code> - The calculation has been queued for processing.
     *        </p>
     *        <p>
     *        <code>RUNNING</code> - The calculation is running.
     *        </p>
     *        <p>
     *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *        to stop it.
     *        </p>
     *        <p>
     *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *        </p>
     *        <p>
     *        <code>COMPLETED</code> - The calculation has completed without error.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */

    public void setStateFilter(String stateFilter) {
        this.stateFilter = stateFilter;
    }

    /**
     * <p>
     * A filter for a specific calculation execution state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * 
     * @return A filter for a specific calculation execution state. A description of each state follows.</p>
     *         <p>
     *         <code>CREATING</code> - The calculation is in the process of being created.
     *         </p>
     *         <p>
     *         <code>CREATED</code> - The calculation has been created and is ready to run.
     *         </p>
     *         <p>
     *         <code>QUEUED</code> - The calculation has been queued for processing.
     *         </p>
     *         <p>
     *         <code>RUNNING</code> - The calculation is running.
     *         </p>
     *         <p>
     *         <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *         to stop it.
     *         </p>
     *         <p>
     *         <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *         </p>
     *         <p>
     *         <code>COMPLETED</code> - The calculation has completed without error.
     *         </p>
     *         <p>
     *         <code>FAILED</code> - The calculation failed and is no longer running.
     * @see CalculationExecutionState
     */

    public String getStateFilter() {
        return this.stateFilter;
    }

    /**
     * <p>
     * A filter for a specific calculation execution state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific calculation execution state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The calculation is in the process of being created.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The calculation has been created and is ready to run.
     *        </p>
     *        <p>
     *        <code>QUEUED</code> - The calculation has been queued for processing.
     *        </p>
     *        <p>
     *        <code>RUNNING</code> - The calculation is running.
     *        </p>
     *        <p>
     *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *        to stop it.
     *        </p>
     *        <p>
     *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *        </p>
     *        <p>
     *        <code>COMPLETED</code> - The calculation has completed without error.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - The calculation failed and is no longer running.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CalculationExecutionState
     */

    public ListCalculationExecutionsRequest withStateFilter(String stateFilter) {
        setStateFilter(stateFilter);
        return this;
    }

    /**
     * <p>
     * A filter for a specific calculation execution state. A description of each state follows.
     * </p>
     * <p>
     * <code>CREATING</code> - The calculation is in the process of being created.
     * </p>
     * <p>
     * <code>CREATED</code> - The calculation has been created and is ready to run.
     * </p>
     * <p>
     * <code>QUEUED</code> - The calculation has been queued for processing.
     * </p>
     * <p>
     * <code>RUNNING</code> - The calculation is running.
     * </p>
     * <p>
     * <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working to stop
     * it.
     * </p>
     * <p>
     * <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     * </p>
     * <p>
     * <code>COMPLETED</code> - The calculation has completed without error.
     * </p>
     * <p>
     * <code>FAILED</code> - The calculation failed and is no longer running.
     * </p>
     * 
     * @param stateFilter
     *        A filter for a specific calculation execution state. A description of each state follows.</p>
     *        <p>
     *        <code>CREATING</code> - The calculation is in the process of being created.
     *        </p>
     *        <p>
     *        <code>CREATED</code> - The calculation has been created and is ready to run.
     *        </p>
     *        <p>
     *        <code>QUEUED</code> - The calculation has been queued for processing.
     *        </p>
     *        <p>
     *        <code>RUNNING</code> - The calculation is running.
     *        </p>
     *        <p>
     *        <code>CANCELING</code> - A request to cancel the calculation has been received and the system is working
     *        to stop it.
     *        </p>
     *        <p>
     *        <code>CANCELED</code> - The calculation is no longer running as the result of a cancel request.
     *        </p>
     *        <p>
     *        <code>COMPLETED</code> - The calculation has completed without error.
     *        </p>
     *        <p>
     *        <code>FAILED</code> - The calculation failed and is no longer running.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see CalculationExecutionState
     */

    public ListCalculationExecutionsRequest withStateFilter(CalculationExecutionState stateFilter) {
        this.stateFilter = stateFilter.toString();
        return this;
    }

    /**
     * <p>
     * The maximum number of calculation executions to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of calculation executions to return.
     */

    public void setMaxResults(Integer maxResults) {
        this.maxResults = maxResults;
    }

    /**
     * <p>
     * The maximum number of calculation executions to return.
     * </p>
     * 
     * @return The maximum number of calculation executions to return.
     */

    public Integer getMaxResults() {
        return this.maxResults;
    }

    /**
     * <p>
     * The maximum number of calculation executions to return.
     * </p>
     * 
     * @param maxResults
     *        The maximum number of calculation executions to return.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsRequest withMaxResults(Integer maxResults) {
        setMaxResults(maxResults);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsRequest withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSessionId() != null)
            sb.append("SessionId: ").append(getSessionId()).append(",");
        if (getStateFilter() != null)
            sb.append("StateFilter: ").append(getStateFilter()).append(",");
        if (getMaxResults() != null)
            sb.append("MaxResults: ").append(getMaxResults()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListCalculationExecutionsRequest == false)
            return false;
        ListCalculationExecutionsRequest other = (ListCalculationExecutionsRequest) obj;
        if (other.getSessionId() == null ^ this.getSessionId() == null)
            return false;
        if (other.getSessionId() != null && other.getSessionId().equals(this.getSessionId()) == false)
            return false;
        if (other.getStateFilter() == null ^ this.getStateFilter() == null)
            return false;
        if (other.getStateFilter() != null && other.getStateFilter().equals(this.getStateFilter()) == false)
            return false;
        if (other.getMaxResults() == null ^ this.getMaxResults() == null)
            return false;
        if (other.getMaxResults() != null && other.getMaxResults().equals(this.getMaxResults()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSessionId() == null) ? 0 : getSessionId().hashCode());
        hashCode = prime * hashCode + ((getStateFilter() == null) ? 0 : getStateFilter().hashCode());
        hashCode = prime * hashCode + ((getMaxResults() == null) ? 0 : getMaxResults().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListCalculationExecutionsRequest clone() {
        return (ListCalculationExecutionsRequest) super.clone();
    }

}
