/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListExecutors" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListExecutorsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The session ID.
     * </p>
     */
    private String sessionId;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * Contains summary information about the executor.
     * </p>
     */
    private java.util.List<ExecutorsSummary> executorsSummary;

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @param sessionId
     *        The session ID.
     */

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */

    public String getSessionId() {
        return this.sessionId;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @param sessionId
     *        The session ID.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutorsResult withSessionId(String sessionId) {
        setSessionId(sessionId);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutorsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * Contains summary information about the executor.
     * </p>
     * 
     * @return Contains summary information about the executor.
     */

    public java.util.List<ExecutorsSummary> getExecutorsSummary() {
        return executorsSummary;
    }

    /**
     * <p>
     * Contains summary information about the executor.
     * </p>
     * 
     * @param executorsSummary
     *        Contains summary information about the executor.
     */

    public void setExecutorsSummary(java.util.Collection<ExecutorsSummary> executorsSummary) {
        if (executorsSummary == null) {
            this.executorsSummary = null;
            return;
        }

        this.executorsSummary = new java.util.ArrayList<ExecutorsSummary>(executorsSummary);
    }

    /**
     * <p>
     * Contains summary information about the executor.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setExecutorsSummary(java.util.Collection)} or {@link #withExecutorsSummary(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param executorsSummary
     *        Contains summary information about the executor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutorsResult withExecutorsSummary(ExecutorsSummary... executorsSummary) {
        if (this.executorsSummary == null) {
            setExecutorsSummary(new java.util.ArrayList<ExecutorsSummary>(executorsSummary.length));
        }
        for (ExecutorsSummary ele : executorsSummary) {
            this.executorsSummary.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * Contains summary information about the executor.
     * </p>
     * 
     * @param executorsSummary
     *        Contains summary information about the executor.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListExecutorsResult withExecutorsSummary(java.util.Collection<ExecutorsSummary> executorsSummary) {
        setExecutorsSummary(executorsSummary);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSessionId() != null)
            sb.append("SessionId: ").append(getSessionId()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getExecutorsSummary() != null)
            sb.append("ExecutorsSummary: ").append(getExecutorsSummary());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListExecutorsResult == false)
            return false;
        ListExecutorsResult other = (ListExecutorsResult) obj;
        if (other.getSessionId() == null ^ this.getSessionId() == null)
            return false;
        if (other.getSessionId() != null && other.getSessionId().equals(this.getSessionId()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getExecutorsSummary() == null ^ this.getExecutorsSummary() == null)
            return false;
        if (other.getExecutorsSummary() != null && other.getExecutorsSummary().equals(this.getExecutorsSummary()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSessionId() == null) ? 0 : getSessionId().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getExecutorsSummary() == null) ? 0 : getExecutorsSummary().hashCode());
        return hashCode;
    }

    @Override
    public ListExecutorsResult clone() {
        try {
            return (ListExecutorsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
