/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListApplicationDPUSizes" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListApplicationDPUSizesResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     */
    private java.util.List<ApplicationDPUSizes> applicationDPUSizes;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     * 
     * @return A list of the supported DPU sizes that the application runtime supports.
     */

    public java.util.List<ApplicationDPUSizes> getApplicationDPUSizes() {
        return applicationDPUSizes;
    }

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     * 
     * @param applicationDPUSizes
     *        A list of the supported DPU sizes that the application runtime supports.
     */

    public void setApplicationDPUSizes(java.util.Collection<ApplicationDPUSizes> applicationDPUSizes) {
        if (applicationDPUSizes == null) {
            this.applicationDPUSizes = null;
            return;
        }

        this.applicationDPUSizes = new java.util.ArrayList<ApplicationDPUSizes>(applicationDPUSizes);
    }

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setApplicationDPUSizes(java.util.Collection)} or {@link #withApplicationDPUSizes(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param applicationDPUSizes
     *        A list of the supported DPU sizes that the application runtime supports.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListApplicationDPUSizesResult withApplicationDPUSizes(ApplicationDPUSizes... applicationDPUSizes) {
        if (this.applicationDPUSizes == null) {
            setApplicationDPUSizes(new java.util.ArrayList<ApplicationDPUSizes>(applicationDPUSizes.length));
        }
        for (ApplicationDPUSizes ele : applicationDPUSizes) {
            this.applicationDPUSizes.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of the supported DPU sizes that the application runtime supports.
     * </p>
     * 
     * @param applicationDPUSizes
     *        A list of the supported DPU sizes that the application runtime supports.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListApplicationDPUSizesResult withApplicationDPUSizes(java.util.Collection<ApplicationDPUSizes> applicationDPUSizes) {
        setApplicationDPUSizes(applicationDPUSizes);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListApplicationDPUSizesResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getApplicationDPUSizes() != null)
            sb.append("ApplicationDPUSizes: ").append(getApplicationDPUSizes()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListApplicationDPUSizesResult == false)
            return false;
        ListApplicationDPUSizesResult other = (ListApplicationDPUSizesResult) obj;
        if (other.getApplicationDPUSizes() == null ^ this.getApplicationDPUSizes() == null)
            return false;
        if (other.getApplicationDPUSizes() != null && other.getApplicationDPUSizes().equals(this.getApplicationDPUSizes()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getApplicationDPUSizes() == null) ? 0 : getApplicationDPUSizes().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListApplicationDPUSizesResult clone() {
        try {
            return (ListApplicationDPUSizesResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
