/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ImportNotebook" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ImportNotebookRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the Spark enabled workgroup to import the notebook to.
     * </p>
     */
    private String workGroup;
    /**
     * <p>
     * The name of the notebook to import.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The notebook content to be imported.
     * </p>
     */
    private String payload;
    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     */
    private String type;
    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     */
    private String clientRequestToken;

    /**
     * <p>
     * The name of the Spark enabled workgroup to import the notebook to.
     * </p>
     * 
     * @param workGroup
     *        The name of the Spark enabled workgroup to import the notebook to.
     */

    public void setWorkGroup(String workGroup) {
        this.workGroup = workGroup;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to import the notebook to.
     * </p>
     * 
     * @return The name of the Spark enabled workgroup to import the notebook to.
     */

    public String getWorkGroup() {
        return this.workGroup;
    }

    /**
     * <p>
     * The name of the Spark enabled workgroup to import the notebook to.
     * </p>
     * 
     * @param workGroup
     *        The name of the Spark enabled workgroup to import the notebook to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportNotebookRequest withWorkGroup(String workGroup) {
        setWorkGroup(workGroup);
        return this;
    }

    /**
     * <p>
     * The name of the notebook to import.
     * </p>
     * 
     * @param name
     *        The name of the notebook to import.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the notebook to import.
     * </p>
     * 
     * @return The name of the notebook to import.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the notebook to import.
     * </p>
     * 
     * @param name
     *        The name of the notebook to import.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportNotebookRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The notebook content to be imported.
     * </p>
     * 
     * @param payload
     *        The notebook content to be imported.
     */

    public void setPayload(String payload) {
        this.payload = payload;
    }

    /**
     * <p>
     * The notebook content to be imported.
     * </p>
     * 
     * @return The notebook content to be imported.
     */

    public String getPayload() {
        return this.payload;
    }

    /**
     * <p>
     * The notebook content to be imported.
     * </p>
     * 
     * @param payload
     *        The notebook content to be imported.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportNotebookRequest withPayload(String payload) {
        setPayload(payload);
        return this;
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * 
     * @param type
     *        The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */

    public void setType(String type) {
        this.type = type;
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * 
     * @return The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @see NotebookType
     */

    public String getType() {
        return this.type;
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * 
     * @param type
     *        The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NotebookType
     */

    public ImportNotebookRequest withType(String type) {
        setType(type);
        return this;
    }

    /**
     * <p>
     * The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * </p>
     * 
     * @param type
     *        The notebook content type. Currently, the only valid type is <code>IPYNB</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see NotebookType
     */

    public ImportNotebookRequest withType(NotebookType type) {
        this.type = type.toString();
        return this;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @param clientRequestToken
     *        A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes
     *        only once).</p> <important>
     *        <p>
     *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
     *        SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the
     *        Amazon Web Services CLI, you must provide this token or the action will fail.
     *        </p>
     */

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @return A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes
     *         only once).</p> <important>
     *         <p>
     *         This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web
     *         Services SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK
     *         or the Amazon Web Services CLI, you must provide this token or the action will fail.
     *         </p>
     */

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    /**
     * <p>
     * A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes only
     * once).
     * </p>
     * <important>
     * <p>
     * This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services SDK
     * for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the Amazon Web
     * Services CLI, you must provide this token or the action will fail.
     * </p>
     * </important>
     * 
     * @param clientRequestToken
     *        A unique case-sensitive string used to ensure the request to import the notebook is idempotent (executes
     *        only once).</p> <important>
     *        <p>
     *        This token is listed as not required because Amazon Web Services SDKs (for example the Amazon Web Services
     *        SDK for Java) auto-generate the token for you. If you are not using the Amazon Web Services SDK or the
     *        Amazon Web Services CLI, you must provide this token or the action will fail.
     *        </p>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ImportNotebookRequest withClientRequestToken(String clientRequestToken) {
        setClientRequestToken(clientRequestToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getWorkGroup() != null)
            sb.append("WorkGroup: ").append(getWorkGroup()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getPayload() != null)
            sb.append("Payload: ").append(getPayload()).append(",");
        if (getType() != null)
            sb.append("Type: ").append(getType()).append(",");
        if (getClientRequestToken() != null)
            sb.append("ClientRequestToken: ").append(getClientRequestToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ImportNotebookRequest == false)
            return false;
        ImportNotebookRequest other = (ImportNotebookRequest) obj;
        if (other.getWorkGroup() == null ^ this.getWorkGroup() == null)
            return false;
        if (other.getWorkGroup() != null && other.getWorkGroup().equals(this.getWorkGroup()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getPayload() == null ^ this.getPayload() == null)
            return false;
        if (other.getPayload() != null && other.getPayload().equals(this.getPayload()) == false)
            return false;
        if (other.getType() == null ^ this.getType() == null)
            return false;
        if (other.getType() != null && other.getType().equals(this.getType()) == false)
            return false;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null)
            return false;
        if (other.getClientRequestToken() != null && other.getClientRequestToken().equals(this.getClientRequestToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getWorkGroup() == null) ? 0 : getWorkGroup().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getPayload() == null) ? 0 : getPayload().hashCode());
        hashCode = prime * hashCode + ((getType() == null) ? 0 : getType().hashCode());
        hashCode = prime * hashCode + ((getClientRequestToken() == null) ? 0 : getClientRequestToken().hashCode());
        return hashCode;
    }

    @Override
    public ImportNotebookRequest clone() {
        return (ImportNotebookRequest) super.clone();
    }

}
