/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.athena.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.athena.model.CalculationStatus;
import java.util.Date;

@SdkInternalApi
public class CalculationStatusMarshaller {
    private static final MarshallingInfo<Date> SUBMISSIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SubmissionDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETIONDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDateTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATECHANGEREASON_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StateChangeReason").build();
    private static final CalculationStatusMarshaller instance = new CalculationStatusMarshaller();

    public static CalculationStatusMarshaller getInstance() {
        return instance;
    }

    public void marshall(CalculationStatus calculationStatus, ProtocolMarshaller protocolMarshaller) {
        if (calculationStatus == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)calculationStatus.getSubmissionDateTime(), SUBMISSIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)calculationStatus.getCompletionDateTime(), COMPLETIONDATETIME_BINDING);
            protocolMarshaller.marshall((Object)calculationStatus.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)calculationStatus.getStateChangeReason(), STATECHANGEREASON_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

