/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListCalculationExecutions" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListCalculationExecutionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     */
    private java.util.List<CalculationSummary> calculations;

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     * 
     * @return A list of <a>CalculationSummary</a> objects.
     */

    public java.util.List<CalculationSummary> getCalculations() {
        return calculations;
    }

    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     * 
     * @param calculations
     *        A list of <a>CalculationSummary</a> objects.
     */

    public void setCalculations(java.util.Collection<CalculationSummary> calculations) {
        if (calculations == null) {
            this.calculations = null;
            return;
        }

        this.calculations = new java.util.ArrayList<CalculationSummary>(calculations);
    }

    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setCalculations(java.util.Collection)} or {@link #withCalculations(java.util.Collection)} if you want to
     * override the existing values.
     * </p>
     * 
     * @param calculations
     *        A list of <a>CalculationSummary</a> objects.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsResult withCalculations(CalculationSummary... calculations) {
        if (this.calculations == null) {
            setCalculations(new java.util.ArrayList<CalculationSummary>(calculations.length));
        }
        for (CalculationSummary ele : calculations) {
            this.calculations.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of <a>CalculationSummary</a> objects.
     * </p>
     * 
     * @param calculations
     *        A list of <a>CalculationSummary</a> objects.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListCalculationExecutionsResult withCalculations(java.util.Collection<CalculationSummary> calculations) {
        setCalculations(calculations);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getCalculations() != null)
            sb.append("Calculations: ").append(getCalculations());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListCalculationExecutionsResult == false)
            return false;
        ListCalculationExecutionsResult other = (ListCalculationExecutionsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getCalculations() == null ^ this.getCalculations() == null)
            return false;
        if (other.getCalculations() != null && other.getCalculations().equals(this.getCalculations()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getCalculations() == null) ? 0 : getCalculations().hashCode());
        return hashCode;
    }

    @Override
    public ListCalculationExecutionsResult clone() {
        try {
            return (ListCalculationExecutionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
