/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.athena.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/athena-2017-05-18/ListNotebookSessions" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListNotebookSessionsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     */
    private java.util.List<NotebookSessionSummary> notebookSessionsList;
    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     */
    private String nextToken;

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     * 
     * @return A list of the sessions belonging to the notebook.
     */

    public java.util.List<NotebookSessionSummary> getNotebookSessionsList() {
        return notebookSessionsList;
    }

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     * 
     * @param notebookSessionsList
     *        A list of the sessions belonging to the notebook.
     */

    public void setNotebookSessionsList(java.util.Collection<NotebookSessionSummary> notebookSessionsList) {
        if (notebookSessionsList == null) {
            this.notebookSessionsList = null;
            return;
        }

        this.notebookSessionsList = new java.util.ArrayList<NotebookSessionSummary>(notebookSessionsList);
    }

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setNotebookSessionsList(java.util.Collection)} or {@link #withNotebookSessionsList(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param notebookSessionsList
     *        A list of the sessions belonging to the notebook.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookSessionsResult withNotebookSessionsList(NotebookSessionSummary... notebookSessionsList) {
        if (this.notebookSessionsList == null) {
            setNotebookSessionsList(new java.util.ArrayList<NotebookSessionSummary>(notebookSessionsList.length));
        }
        for (NotebookSessionSummary ele : notebookSessionsList) {
            this.notebookSessionsList.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * A list of the sessions belonging to the notebook.
     * </p>
     * 
     * @param notebookSessionsList
     *        A list of the sessions belonging to the notebook.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookSessionsResult withNotebookSessionsList(java.util.Collection<NotebookSessionSummary> notebookSessionsList) {
        setNotebookSessionsList(notebookSessionsList);
        return this;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @return A token generated by the Athena service that specifies where to continue pagination if a previous request
     *         was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *         object of the previous page call.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * A token generated by the Athena service that specifies where to continue pagination if a previous request was
     * truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response object of the
     * previous page call.
     * </p>
     * 
     * @param nextToken
     *        A token generated by the Athena service that specifies where to continue pagination if a previous request
     *        was truncated. To obtain the next set of pages, pass in the <code>NextToken</code> from the response
     *        object of the previous page call.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListNotebookSessionsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNotebookSessionsList() != null)
            sb.append("NotebookSessionsList: ").append(getNotebookSessionsList()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListNotebookSessionsResult == false)
            return false;
        ListNotebookSessionsResult other = (ListNotebookSessionsResult) obj;
        if (other.getNotebookSessionsList() == null ^ this.getNotebookSessionsList() == null)
            return false;
        if (other.getNotebookSessionsList() != null && other.getNotebookSessionsList().equals(this.getNotebookSessionsList()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNotebookSessionsList() == null) ? 0 : getNotebookSessionsList().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListNotebookSessionsResult clone() {
        try {
            return (ListNotebookSessionsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
