/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.auditmanager.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/auditmanager-2017-07-25/CreateAssessmentReport"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateAssessmentReportRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The name of the new assessment report.
     * </p>
     */
    private String name;
    /**
     * <p>
     * The description of the assessment report.
     * </p>
     */
    private String description;
    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     */
    private String assessmentId;
    /**
     * <p>
     * A SQL statement that represents an evidence finder query.
     * </p>
     * <p>
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
     * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from
     * the query output. This report does not include any assessment evidence that was manually <a href=
     * "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     * >added to a report using the console</a>, or <a
     * href="https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     * >associated with a report using the API</a>.
     * </p>
     * <p>
     * To use this parameter, the <a href=
     * "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     * </p>
     * <p>
     * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     * >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     * </p>
     */
    private String queryStatement;

    /**
     * <p>
     * The name of the new assessment report.
     * </p>
     * 
     * @param name
     *        The name of the new assessment report.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the new assessment report.
     * </p>
     * 
     * @return The name of the new assessment report.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the new assessment report.
     * </p>
     * 
     * @param name
     *        The name of the new assessment report.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssessmentReportRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * The description of the assessment report.
     * </p>
     * 
     * @param description
     *        The description of the assessment report.
     */

    public void setDescription(String description) {
        this.description = description;
    }

    /**
     * <p>
     * The description of the assessment report.
     * </p>
     * 
     * @return The description of the assessment report.
     */

    public String getDescription() {
        return this.description;
    }

    /**
     * <p>
     * The description of the assessment report.
     * </p>
     * 
     * @param description
     *        The description of the assessment report.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssessmentReportRequest withDescription(String description) {
        setDescription(description);
        return this;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @param assessmentId
     *        The identifier for the assessment.
     */

    public void setAssessmentId(String assessmentId) {
        this.assessmentId = assessmentId;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @return The identifier for the assessment.
     */

    public String getAssessmentId() {
        return this.assessmentId;
    }

    /**
     * <p>
     * The identifier for the assessment.
     * </p>
     * 
     * @param assessmentId
     *        The identifier for the assessment.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssessmentReportRequest withAssessmentId(String assessmentId) {
        setAssessmentId(assessmentId);
        return this;
    }

    /**
     * <p>
     * A SQL statement that represents an evidence finder query.
     * </p>
     * <p>
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
     * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from
     * the query output. This report does not include any assessment evidence that was manually <a href=
     * "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     * >added to a report using the console</a>, or <a
     * href="https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     * >associated with a report using the API</a>.
     * </p>
     * <p>
     * To use this parameter, the <a href=
     * "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     * </p>
     * <p>
     * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     * >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     * </p>
     * 
     * @param queryStatement
     *        A SQL statement that represents an evidence finder query.</p>
     *        <p>
     *        Provide this parameter when you want to generate an assessment report from the results of an evidence
     *        finder search query. When you use this parameter, Audit Manager generates a one-time report using only the
     *        evidence from the query output. This report does not include any assessment evidence that was manually <a
     *        href=
     *        "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     *        >added to a report using the console</a>, or <a href=
     *        "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     *        >associated with a report using the API</a>.
     *        </p>
     *        <p>
     *        To use this parameter, the <a href=
     *        "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     *        >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     *        </p>
     *        <p>
     *        For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     *        "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     *        >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     */

    public void setQueryStatement(String queryStatement) {
        this.queryStatement = queryStatement;
    }

    /**
     * <p>
     * A SQL statement that represents an evidence finder query.
     * </p>
     * <p>
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
     * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from
     * the query output. This report does not include any assessment evidence that was manually <a href=
     * "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     * >added to a report using the console</a>, or <a
     * href="https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     * >associated with a report using the API</a>.
     * </p>
     * <p>
     * To use this parameter, the <a href=
     * "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     * </p>
     * <p>
     * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     * >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     * </p>
     * 
     * @return A SQL statement that represents an evidence finder query.</p>
     *         <p>
     *         Provide this parameter when you want to generate an assessment report from the results of an evidence
     *         finder search query. When you use this parameter, Audit Manager generates a one-time report using only
     *         the evidence from the query output. This report does not include any assessment evidence that was
     *         manually <a href=
     *         "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     *         >added to a report using the console</a>, or <a href=
     *         "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     *         >associated with a report using the API</a>.
     *         </p>
     *         <p>
     *         To use this parameter, the <a href=
     *         "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     *         >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     *         </p>
     *         <p>
     *         For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     *         "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     *         >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     */

    public String getQueryStatement() {
        return this.queryStatement;
    }

    /**
     * <p>
     * A SQL statement that represents an evidence finder query.
     * </p>
     * <p>
     * Provide this parameter when you want to generate an assessment report from the results of an evidence finder
     * search query. When you use this parameter, Audit Manager generates a one-time report using only the evidence from
     * the query output. This report does not include any assessment evidence that was manually <a href=
     * "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     * >added to a report using the console</a>, or <a
     * href="https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     * >associated with a report using the API</a>.
     * </p>
     * <p>
     * To use this parameter, the <a href=
     * "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     * >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     * </p>
     * <p>
     * For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     * "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     * >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     * </p>
     * 
     * @param queryStatement
     *        A SQL statement that represents an evidence finder query.</p>
     *        <p>
     *        Provide this parameter when you want to generate an assessment report from the results of an evidence
     *        finder search query. When you use this parameter, Audit Manager generates a one-time report using only the
     *        evidence from the query output. This report does not include any assessment evidence that was manually <a
     *        href=
     *        "https://docs.aws.amazon.com/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence"
     *        >added to a report using the console</a>, or <a href=
     *        "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_BatchAssociateAssessmentReportEvidence.html"
     *        >associated with a report using the API</a>.
     *        </p>
     *        <p>
     *        To use this parameter, the <a href=
     *        "https://docs.aws.amazon.com/APIReference-evidenceFinder/API_EvidenceFinderSetup.html#auditmanager-Type-EvidenceFinderSetup-enablementStatus"
     *        >enablementStatus</a> of evidence finder must be <code>ENABLED</code>.
     *        </p>
     *        <p>
     *        For examples and help resolving <code>queryStatement</code> validation exceptions, see <a href=
     *        "https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions"
     *        >Troubleshooting evidence finder issues</a> in the AWS Audit Manager User Guide.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateAssessmentReportRequest withQueryStatement(String queryStatement) {
        setQueryStatement(queryStatement);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getDescription() != null)
            sb.append("Description: ").append(getDescription()).append(",");
        if (getAssessmentId() != null)
            sb.append("AssessmentId: ").append(getAssessmentId()).append(",");
        if (getQueryStatement() != null)
            sb.append("QueryStatement: ").append(getQueryStatement());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateAssessmentReportRequest == false)
            return false;
        CreateAssessmentReportRequest other = (CreateAssessmentReportRequest) obj;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getDescription() == null ^ this.getDescription() == null)
            return false;
        if (other.getDescription() != null && other.getDescription().equals(this.getDescription()) == false)
            return false;
        if (other.getAssessmentId() == null ^ this.getAssessmentId() == null)
            return false;
        if (other.getAssessmentId() != null && other.getAssessmentId().equals(this.getAssessmentId()) == false)
            return false;
        if (other.getQueryStatement() == null ^ this.getQueryStatement() == null)
            return false;
        if (other.getQueryStatement() != null && other.getQueryStatement().equals(this.getQueryStatement()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getDescription() == null) ? 0 : getDescription().hashCode());
        hashCode = prime * hashCode + ((getAssessmentId() == null) ? 0 : getAssessmentId().hashCode());
        hashCode = prime * hashCode + ((getQueryStatement() == null) ? 0 : getQueryStatement().hashCode());
        return hashCode;
    }

    @Override
    public CreateAssessmentReportRequest clone() {
        return (CreateAssessmentReportRequest) super.clone();
    }

}
