/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.auditmanager.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.auditmanager.model.ControlMappingSource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateControlRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String controlId;
    private String name;
    private String description;
    private String testingInformation;
    private String actionPlanTitle;
    private String actionPlanInstructions;
    private List<ControlMappingSource> controlMappingSources;

    public void setControlId(String controlId) {
        this.controlId = controlId;
    }

    public String getControlId() {
        return this.controlId;
    }

    public UpdateControlRequest withControlId(String controlId) {
        this.setControlId(controlId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public UpdateControlRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public UpdateControlRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setTestingInformation(String testingInformation) {
        this.testingInformation = testingInformation;
    }

    public String getTestingInformation() {
        return this.testingInformation;
    }

    public UpdateControlRequest withTestingInformation(String testingInformation) {
        this.setTestingInformation(testingInformation);
        return this;
    }

    public void setActionPlanTitle(String actionPlanTitle) {
        this.actionPlanTitle = actionPlanTitle;
    }

    public String getActionPlanTitle() {
        return this.actionPlanTitle;
    }

    public UpdateControlRequest withActionPlanTitle(String actionPlanTitle) {
        this.setActionPlanTitle(actionPlanTitle);
        return this;
    }

    public void setActionPlanInstructions(String actionPlanInstructions) {
        this.actionPlanInstructions = actionPlanInstructions;
    }

    public String getActionPlanInstructions() {
        return this.actionPlanInstructions;
    }

    public UpdateControlRequest withActionPlanInstructions(String actionPlanInstructions) {
        this.setActionPlanInstructions(actionPlanInstructions);
        return this;
    }

    public List<ControlMappingSource> getControlMappingSources() {
        return this.controlMappingSources;
    }

    public void setControlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
        if (controlMappingSources == null) {
            this.controlMappingSources = null;
            return;
        }
        this.controlMappingSources = new ArrayList<ControlMappingSource>(controlMappingSources);
    }

    public UpdateControlRequest withControlMappingSources(ControlMappingSource ... controlMappingSources) {
        if (this.controlMappingSources == null) {
            this.setControlMappingSources(new ArrayList<ControlMappingSource>(controlMappingSources.length));
        }
        for (ControlMappingSource ele : controlMappingSources) {
            this.controlMappingSources.add(ele);
        }
        return this;
    }

    public UpdateControlRequest withControlMappingSources(Collection<ControlMappingSource> controlMappingSources) {
        this.setControlMappingSources(controlMappingSources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getControlId() != null) {
            sb.append("ControlId: ").append(this.getControlId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTestingInformation() != null) {
            sb.append("TestingInformation: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getActionPlanTitle() != null) {
            sb.append("ActionPlanTitle: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getActionPlanInstructions() != null) {
            sb.append("ActionPlanInstructions: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getControlMappingSources() != null) {
            sb.append("ControlMappingSources: ").append(this.getControlMappingSources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateControlRequest)) {
            return false;
        }
        UpdateControlRequest other = (UpdateControlRequest)obj;
        if (other.getControlId() == null ^ this.getControlId() == null) {
            return false;
        }
        if (other.getControlId() != null && !other.getControlId().equals(this.getControlId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTestingInformation() == null ^ this.getTestingInformation() == null) {
            return false;
        }
        if (other.getTestingInformation() != null && !other.getTestingInformation().equals(this.getTestingInformation())) {
            return false;
        }
        if (other.getActionPlanTitle() == null ^ this.getActionPlanTitle() == null) {
            return false;
        }
        if (other.getActionPlanTitle() != null && !other.getActionPlanTitle().equals(this.getActionPlanTitle())) {
            return false;
        }
        if (other.getActionPlanInstructions() == null ^ this.getActionPlanInstructions() == null) {
            return false;
        }
        if (other.getActionPlanInstructions() != null && !other.getActionPlanInstructions().equals(this.getActionPlanInstructions())) {
            return false;
        }
        if (other.getControlMappingSources() == null ^ this.getControlMappingSources() == null) {
            return false;
        }
        return other.getControlMappingSources() == null || other.getControlMappingSources().equals(this.getControlMappingSources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getControlId() == null ? 0 : this.getControlId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTestingInformation() == null ? 0 : this.getTestingInformation().hashCode());
        hashCode = 31 * hashCode + (this.getActionPlanTitle() == null ? 0 : this.getActionPlanTitle().hashCode());
        hashCode = 31 * hashCode + (this.getActionPlanInstructions() == null ? 0 : this.getActionPlanInstructions().hashCode());
        hashCode = 31 * hashCode + (this.getControlMappingSources() == null ? 0 : this.getControlMappingSources().hashCode());
        return hashCode;
    }

    public UpdateControlRequest clone() {
        return (UpdateControlRequest)super.clone();
    }
}

