/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.augmentedairuntime;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.augmentedairuntime.AmazonAugmentedAIRuntime;
import com.amazonaws.services.augmentedairuntime.AmazonAugmentedAIRuntimeClientBuilder;
import com.amazonaws.services.augmentedairuntime.model.AmazonAugmentedAIRuntimeException;
import com.amazonaws.services.augmentedairuntime.model.DeleteHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.DeleteHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.DescribeHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.DescribeHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.ListHumanLoopsRequest;
import com.amazonaws.services.augmentedairuntime.model.ListHumanLoopsResult;
import com.amazonaws.services.augmentedairuntime.model.StartHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.StartHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.StopHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.StopHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.transform.ConflictExceptionUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.DeleteHumanLoopRequestProtocolMarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.DeleteHumanLoopResultJsonUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.DescribeHumanLoopRequestProtocolMarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.DescribeHumanLoopResultJsonUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.InternalServerExceptionUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ListHumanLoopsRequestProtocolMarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ListHumanLoopsResultJsonUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ServiceQuotaExceededExceptionUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.StartHumanLoopRequestProtocolMarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.StartHumanLoopResultJsonUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.StopHumanLoopRequestProtocolMarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.StopHumanLoopResultJsonUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ThrottlingExceptionUnmarshaller;
import com.amazonaws.services.augmentedairuntime.model.transform.ValidationExceptionUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonAugmentedAIRuntimeClient
extends AmazonWebServiceClient
implements AmazonAugmentedAIRuntime {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonAugmentedAIRuntime.class);
    private static final String DEFAULT_SIGNING_NAME = "sagemaker";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ValidationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ValidationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConflictException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConflictExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalServerException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalServerExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ThrottlingException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ThrottlingExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServiceQuotaExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ServiceQuotaExceededExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonAugmentedAIRuntimeException.class));

    public static AmazonAugmentedAIRuntimeClientBuilder builder() {
        return AmazonAugmentedAIRuntimeClientBuilder.standard();
    }

    AmazonAugmentedAIRuntimeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonAugmentedAIRuntimeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix("a2i-runtime.sagemaker");
        this.setEndpoint("a2i-runtime.sagemaker.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/augmentedairuntime/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/augmentedairuntime/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public DeleteHumanLoopResult deleteHumanLoop(DeleteHumanLoopRequest request) {
        request = (DeleteHumanLoopRequest)this.beforeClientExecution(request);
        return this.executeDeleteHumanLoop(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteHumanLoopResult executeDeleteHumanLoop(DeleteHumanLoopRequest deleteHumanLoopRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteHumanLoopRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteHumanLoopRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteHumanLoopRequestProtocolMarshaller(protocolFactory).marshall((DeleteHumanLoopRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteHumanLoopRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker A2I Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteHumanLoop");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteHumanLoopResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteHumanLoopResult deleteHumanLoopResult = (DeleteHumanLoopResult)response.getAwsResponse();
            return deleteHumanLoopResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeHumanLoopResult describeHumanLoop(DescribeHumanLoopRequest request) {
        request = (DescribeHumanLoopRequest)this.beforeClientExecution(request);
        return this.executeDescribeHumanLoop(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeHumanLoopResult executeDescribeHumanLoop(DescribeHumanLoopRequest describeHumanLoopRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeHumanLoopRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeHumanLoopRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeHumanLoopRequestProtocolMarshaller(protocolFactory).marshall((DescribeHumanLoopRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeHumanLoopRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker A2I Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeHumanLoop");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeHumanLoopResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeHumanLoopResult describeHumanLoopResult = (DescribeHumanLoopResult)response.getAwsResponse();
            return describeHumanLoopResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListHumanLoopsResult listHumanLoops(ListHumanLoopsRequest request) {
        request = (ListHumanLoopsRequest)this.beforeClientExecution(request);
        return this.executeListHumanLoops(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListHumanLoopsResult executeListHumanLoops(ListHumanLoopsRequest listHumanLoopsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listHumanLoopsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListHumanLoopsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListHumanLoopsRequestProtocolMarshaller(protocolFactory).marshall((ListHumanLoopsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listHumanLoopsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker A2I Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListHumanLoops");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListHumanLoopsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListHumanLoopsResult listHumanLoopsResult = (ListHumanLoopsResult)response.getAwsResponse();
            return listHumanLoopsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartHumanLoopResult startHumanLoop(StartHumanLoopRequest request) {
        request = (StartHumanLoopRequest)this.beforeClientExecution(request);
        return this.executeStartHumanLoop(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartHumanLoopResult executeStartHumanLoop(StartHumanLoopRequest startHumanLoopRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startHumanLoopRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartHumanLoopRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartHumanLoopRequestProtocolMarshaller(protocolFactory).marshall((StartHumanLoopRequest)super.beforeMarshalling((AmazonWebServiceRequest)startHumanLoopRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker A2I Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartHumanLoop");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartHumanLoopResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartHumanLoopResult startHumanLoopResult = (StartHumanLoopResult)response.getAwsResponse();
            return startHumanLoopResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StopHumanLoopResult stopHumanLoop(StopHumanLoopRequest request) {
        request = (StopHumanLoopRequest)this.beforeClientExecution(request);
        return this.executeStopHumanLoop(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StopHumanLoopResult executeStopHumanLoop(StopHumanLoopRequest stopHumanLoopRequest) {
        ExecutionContext executionContext = this.createExecutionContext(stopHumanLoopRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StopHumanLoopRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StopHumanLoopRequestProtocolMarshaller(protocolFactory).marshall((StopHumanLoopRequest)super.beforeMarshalling((AmazonWebServiceRequest)stopHumanLoopRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"SageMaker A2I Runtime");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StopHumanLoop");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StopHumanLoopResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StopHumanLoopResult stopHumanLoopResult = (StopHumanLoopResult)response.getAwsResponse();
            return stopHumanLoopResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

