/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.augmentedairuntime;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.augmentedairuntime.AmazonAugmentedAIRuntimeAsync;
import com.amazonaws.services.augmentedairuntime.AmazonAugmentedAIRuntimeAsyncClientBuilder;
import com.amazonaws.services.augmentedairuntime.AmazonAugmentedAIRuntimeClient;
import com.amazonaws.services.augmentedairuntime.model.DeleteHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.DeleteHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.DescribeHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.DescribeHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.ListHumanLoopsRequest;
import com.amazonaws.services.augmentedairuntime.model.ListHumanLoopsResult;
import com.amazonaws.services.augmentedairuntime.model.StartHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.StartHumanLoopResult;
import com.amazonaws.services.augmentedairuntime.model.StopHumanLoopRequest;
import com.amazonaws.services.augmentedairuntime.model.StopHumanLoopResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonAugmentedAIRuntimeAsyncClient
extends AmazonAugmentedAIRuntimeClient
implements AmazonAugmentedAIRuntimeAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public static AmazonAugmentedAIRuntimeAsyncClientBuilder asyncBuilder() {
        return AmazonAugmentedAIRuntimeAsyncClientBuilder.standard();
    }

    AmazonAugmentedAIRuntimeAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super((AwsSyncClientParams)asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<DeleteHumanLoopResult> deleteHumanLoopAsync(DeleteHumanLoopRequest request) {
        return this.deleteHumanLoopAsync(request, null);
    }

    @Override
    public Future<DeleteHumanLoopResult> deleteHumanLoopAsync(DeleteHumanLoopRequest request, final AsyncHandler<DeleteHumanLoopRequest, DeleteHumanLoopResult> asyncHandler) {
        final DeleteHumanLoopRequest finalRequest = (DeleteHumanLoopRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DeleteHumanLoopResult>(){

            @Override
            public DeleteHumanLoopResult call() throws Exception {
                DeleteHumanLoopResult result = null;
                try {
                    result = AmazonAugmentedAIRuntimeAsyncClient.this.executeDeleteHumanLoop(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeHumanLoopResult> describeHumanLoopAsync(DescribeHumanLoopRequest request) {
        return this.describeHumanLoopAsync(request, null);
    }

    @Override
    public Future<DescribeHumanLoopResult> describeHumanLoopAsync(DescribeHumanLoopRequest request, final AsyncHandler<DescribeHumanLoopRequest, DescribeHumanLoopResult> asyncHandler) {
        final DescribeHumanLoopRequest finalRequest = (DescribeHumanLoopRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<DescribeHumanLoopResult>(){

            @Override
            public DescribeHumanLoopResult call() throws Exception {
                DescribeHumanLoopResult result = null;
                try {
                    result = AmazonAugmentedAIRuntimeAsyncClient.this.executeDescribeHumanLoop(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListHumanLoopsResult> listHumanLoopsAsync(ListHumanLoopsRequest request) {
        return this.listHumanLoopsAsync(request, null);
    }

    @Override
    public Future<ListHumanLoopsResult> listHumanLoopsAsync(ListHumanLoopsRequest request, final AsyncHandler<ListHumanLoopsRequest, ListHumanLoopsResult> asyncHandler) {
        final ListHumanLoopsRequest finalRequest = (ListHumanLoopsRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<ListHumanLoopsResult>(){

            @Override
            public ListHumanLoopsResult call() throws Exception {
                ListHumanLoopsResult result = null;
                try {
                    result = AmazonAugmentedAIRuntimeAsyncClient.this.executeListHumanLoops(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StartHumanLoopResult> startHumanLoopAsync(StartHumanLoopRequest request) {
        return this.startHumanLoopAsync(request, null);
    }

    @Override
    public Future<StartHumanLoopResult> startHumanLoopAsync(StartHumanLoopRequest request, final AsyncHandler<StartHumanLoopRequest, StartHumanLoopResult> asyncHandler) {
        final StartHumanLoopRequest finalRequest = (StartHumanLoopRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StartHumanLoopResult>(){

            @Override
            public StartHumanLoopResult call() throws Exception {
                StartHumanLoopResult result = null;
                try {
                    result = AmazonAugmentedAIRuntimeAsyncClient.this.executeStartHumanLoop(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<StopHumanLoopResult> stopHumanLoopAsync(StopHumanLoopRequest request) {
        return this.stopHumanLoopAsync(request, null);
    }

    @Override
    public Future<StopHumanLoopResult> stopHumanLoopAsync(StopHumanLoopRequest request, final AsyncHandler<StopHumanLoopRequest, StopHumanLoopResult> asyncHandler) {
        final StopHumanLoopRequest finalRequest = (StopHumanLoopRequest)this.beforeClientExecution(request);
        return this.executorService.submit(new Callable<StopHumanLoopResult>(){

            @Override
            public StopHumanLoopResult call() throws Exception {
                StopHumanLoopResult result = null;
                try {
                    result = AmazonAugmentedAIRuntimeAsyncClient.this.executeStopHumanLoop(finalRequest);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)finalRequest, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

