/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.CreateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.LifecycleHookSpecification;
import com.amazonaws.services.autoscaling.model.Tag;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<CreateAutoScalingGroupRequest>, CreateAutoScalingGroupRequest> {
    public Request<CreateAutoScalingGroupRequest> marshall(CreateAutoScalingGroupRequest createAutoScalingGroupRequest) {
        SdkInternalList tagsList;
        SdkInternalList lifecycleHookSpecificationListList;
        SdkInternalList terminationPoliciesList;
        SdkInternalList targetGroupARNsList;
        SdkInternalList loadBalancerNamesList;
        SdkInternalList availabilityZonesList;
        if (createAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "CreateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)createAutoScalingGroupRequest.getAutoScalingGroupName()));
        }
        if (createAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)createAutoScalingGroupRequest.getLaunchConfigurationName()));
        }
        if (createAutoScalingGroupRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)createAutoScalingGroupRequest.getInstanceId()));
        }
        if (createAutoScalingGroupRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getMinSize()));
        }
        if (createAutoScalingGroupRequest.getMaxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getMaxSize()));
        }
        if (createAutoScalingGroupRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getDesiredCapacity()));
        }
        if (createAutoScalingGroupRequest.getDefaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getDefaultCooldown()));
        }
        if (!(availabilityZonesList = (SdkInternalList)createAutoScalingGroupRequest.getAvailabilityZones()).isEmpty() || !availabilityZonesList.isAutoConstruct()) {
            int availabilityZonesListIndex = 1;
            for (Object availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (!(loadBalancerNamesList = (SdkInternalList)createAutoScalingGroupRequest.getLoadBalancerNames()).isEmpty() || !loadBalancerNamesList.isAutoConstruct()) {
            int loadBalancerNamesListIndex = 1;
            for (Object loadBalancerNamesListValue : loadBalancerNamesList) {
                if (loadBalancerNamesListValue != null) {
                    request.addParameter("LoadBalancerNames.member." + loadBalancerNamesListIndex, StringUtils.fromString((String)loadBalancerNamesListValue));
                }
                ++loadBalancerNamesListIndex;
            }
        }
        if (!(targetGroupARNsList = (SdkInternalList)createAutoScalingGroupRequest.getTargetGroupARNs()).isEmpty() || !targetGroupARNsList.isAutoConstruct()) {
            int targetGroupARNsListIndex = 1;
            for (Object targetGroupARNsListValue : targetGroupARNsList) {
                if (targetGroupARNsListValue != null) {
                    request.addParameter("TargetGroupARNs.member." + targetGroupARNsListIndex, StringUtils.fromString((String)targetGroupARNsListValue));
                }
                ++targetGroupARNsListIndex;
            }
        }
        if (createAutoScalingGroupRequest.getHealthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)createAutoScalingGroupRequest.getHealthCheckType()));
        }
        if (createAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)createAutoScalingGroupRequest.getHealthCheckGracePeriod()));
        }
        if (createAutoScalingGroupRequest.getPlacementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)createAutoScalingGroupRequest.getPlacementGroup()));
        }
        if (createAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)createAutoScalingGroupRequest.getVPCZoneIdentifier()));
        }
        if (!(terminationPoliciesList = (SdkInternalList)createAutoScalingGroupRequest.getTerminationPolicies()).isEmpty() || !terminationPoliciesList.isAutoConstruct()) {
            int terminationPoliciesListIndex = 1;
            for (Object terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (createAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)createAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn()));
        }
        if (!(lifecycleHookSpecificationListList = (SdkInternalList)createAutoScalingGroupRequest.getLifecycleHookSpecificationList()).isEmpty() || !lifecycleHookSpecificationListList.isAutoConstruct()) {
            int lifecycleHookSpecificationListListIndex = 1;
            for (LifecycleHookSpecification lifecycleHookSpecificationListListValue : lifecycleHookSpecificationListList) {
                if (lifecycleHookSpecificationListListValue.getLifecycleHookName() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".LifecycleHookName", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getLifecycleHookName()));
                }
                if (lifecycleHookSpecificationListListValue.getLifecycleTransition() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".LifecycleTransition", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getLifecycleTransition()));
                }
                if (lifecycleHookSpecificationListListValue.getNotificationMetadata() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".NotificationMetadata", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getNotificationMetadata()));
                }
                if (lifecycleHookSpecificationListListValue.getHeartbeatTimeout() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".HeartbeatTimeout", StringUtils.fromInteger((Integer)lifecycleHookSpecificationListListValue.getHeartbeatTimeout()));
                }
                if (lifecycleHookSpecificationListListValue.getDefaultResult() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".DefaultResult", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getDefaultResult()));
                }
                if (lifecycleHookSpecificationListListValue.getNotificationTargetARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".NotificationTargetARN", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getNotificationTargetARN()));
                }
                if (lifecycleHookSpecificationListListValue.getRoleARN() != null) {
                    request.addParameter("LifecycleHookSpecificationList.member." + lifecycleHookSpecificationListListIndex + ".RoleARN", StringUtils.fromString((String)lifecycleHookSpecificationListListValue.getRoleARN()));
                }
                ++lifecycleHookSpecificationListListIndex;
            }
        }
        if (!(tagsList = (SdkInternalList)createAutoScalingGroupRequest.getTags()).isEmpty() || !tagsList.isAutoConstruct()) {
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getResourceId() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceId", StringUtils.fromString((String)tagsListValue.getResourceId()));
                }
                if (tagsListValue.getResourceType() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".ResourceType", StringUtils.fromString((String)tagsListValue.getResourceType()));
                }
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Key", StringUtils.fromString((String)tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".Value", StringUtils.fromString((String)tagsListValue.getValue()));
                }
                if (tagsListValue.getPropagateAtLaunch() != null) {
                    request.addParameter("Tags.member." + tagsListIndex + ".PropagateAtLaunch", StringUtils.fromBoolean((Boolean)tagsListValue.getPropagateAtLaunch()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

