/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.AcceleratorCountRequest;
import com.amazonaws.services.autoscaling.model.AcceleratorTotalMemoryMiBRequest;
import com.amazonaws.services.autoscaling.model.BaselineEbsBandwidthMbpsRequest;
import com.amazonaws.services.autoscaling.model.InstanceRequirements;
import com.amazonaws.services.autoscaling.model.InstancesDistribution;
import com.amazonaws.services.autoscaling.model.LaunchTemplate;
import com.amazonaws.services.autoscaling.model.LaunchTemplateOverrides;
import com.amazonaws.services.autoscaling.model.LaunchTemplateSpecification;
import com.amazonaws.services.autoscaling.model.MemoryGiBPerVCpuRequest;
import com.amazonaws.services.autoscaling.model.MemoryMiBRequest;
import com.amazonaws.services.autoscaling.model.MixedInstancesPolicy;
import com.amazonaws.services.autoscaling.model.NetworkBandwidthGbpsRequest;
import com.amazonaws.services.autoscaling.model.NetworkInterfaceCountRequest;
import com.amazonaws.services.autoscaling.model.TotalLocalStorageGBRequest;
import com.amazonaws.services.autoscaling.model.UpdateAutoScalingGroupRequest;
import com.amazonaws.services.autoscaling.model.VCpuCountRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class UpdateAutoScalingGroupRequestMarshaller
implements Marshaller<Request<UpdateAutoScalingGroupRequest>, UpdateAutoScalingGroupRequest> {
    public Request<UpdateAutoScalingGroupRequest> marshall(UpdateAutoScalingGroupRequest updateAutoScalingGroupRequest) {
        MixedInstancesPolicy mixedInstancesPolicy;
        LaunchTemplateSpecification launchTemplate;
        if (updateAutoScalingGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateAutoScalingGroupRequest, "AmazonAutoScaling");
        request.addParameter("Action", "UpdateAutoScalingGroup");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateAutoScalingGroupRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)updateAutoScalingGroupRequest.getAutoScalingGroupName()));
        }
        if (updateAutoScalingGroupRequest.getLaunchConfigurationName() != null) {
            request.addParameter("LaunchConfigurationName", StringUtils.fromString((String)updateAutoScalingGroupRequest.getLaunchConfigurationName()));
        }
        if ((launchTemplate = updateAutoScalingGroupRequest.getLaunchTemplate()) != null) {
            if (launchTemplate.getLaunchTemplateId() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateId", StringUtils.fromString((String)launchTemplate.getLaunchTemplateId()));
            }
            if (launchTemplate.getLaunchTemplateName() != null) {
                request.addParameter("LaunchTemplate.LaunchTemplateName", StringUtils.fromString((String)launchTemplate.getLaunchTemplateName()));
            }
            if (launchTemplate.getVersion() != null) {
                request.addParameter("LaunchTemplate.Version", StringUtils.fromString((String)launchTemplate.getVersion()));
            }
        }
        if ((mixedInstancesPolicy = updateAutoScalingGroupRequest.getMixedInstancesPolicy()) != null) {
            InstancesDistribution instancesDistribution;
            LaunchTemplate launchTemplate2 = mixedInstancesPolicy.getLaunchTemplate();
            if (launchTemplate2 != null) {
                LaunchTemplateSpecification launchTemplateSpecification = launchTemplate2.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!launchTemplate2.getOverrides().isEmpty() || !((SdkInternalList)launchTemplate2.getOverrides()).isAutoConstruct()) {
                    SdkInternalList overridesList = (SdkInternalList)launchTemplate2.getOverrides();
                    int overridesListIndex = 1;
                    for (LaunchTemplateOverrides overridesListValue : overridesList) {
                        if (overridesListValue != null) {
                            InstanceRequirements instanceRequirements;
                            LaunchTemplateSpecification launchTemplateSpecification2;
                            if (overridesListValue.getInstanceType() != null) {
                                request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)overridesListValue.getInstanceType()));
                            }
                            if (overridesListValue.getWeightedCapacity() != null) {
                                request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".WeightedCapacity", StringUtils.fromString((String)overridesListValue.getWeightedCapacity()));
                            }
                            if ((launchTemplateSpecification2 = overridesListValue.getLaunchTemplateSpecification()) != null) {
                                if (launchTemplateSpecification2.getLaunchTemplateId() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification2.getLaunchTemplateId()));
                                }
                                if (launchTemplateSpecification2.getLaunchTemplateName() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification2.getLaunchTemplateName()));
                                }
                                if (launchTemplateSpecification2.getVersion() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification2.getVersion()));
                                }
                            }
                            if ((instanceRequirements = overridesListValue.getInstanceRequirements()) != null) {
                                NetworkBandwidthGbpsRequest networkBandwidthGbps;
                                AcceleratorTotalMemoryMiBRequest acceleratorTotalMemoryMiB;
                                AcceleratorCountRequest acceleratorCount;
                                BaselineEbsBandwidthMbpsRequest baselineEbsBandwidthMbps;
                                TotalLocalStorageGBRequest totalLocalStorageGB;
                                NetworkInterfaceCountRequest networkInterfaceCount;
                                MemoryGiBPerVCpuRequest memoryGiBPerVCpu;
                                MemoryMiBRequest memoryMiB;
                                VCpuCountRequest vCpuCount = instanceRequirements.getVCpuCount();
                                if (vCpuCount != null) {
                                    if (vCpuCount.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.VCpuCount.Min", StringUtils.fromInteger((Integer)vCpuCount.getMin()));
                                    }
                                    if (vCpuCount.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.VCpuCount.Max", StringUtils.fromInteger((Integer)vCpuCount.getMax()));
                                    }
                                }
                                if ((memoryMiB = instanceRequirements.getMemoryMiB()) != null) {
                                    if (memoryMiB.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Min", StringUtils.fromInteger((Integer)memoryMiB.getMin()));
                                    }
                                    if (memoryMiB.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.MemoryMiB.Max", StringUtils.fromInteger((Integer)memoryMiB.getMax()));
                                    }
                                }
                                if (!instanceRequirements.getCpuManufacturers().isEmpty() || !((SdkInternalList)instanceRequirements.getCpuManufacturers()).isAutoConstruct()) {
                                    SdkInternalList cpuManufacturersList = (SdkInternalList)instanceRequirements.getCpuManufacturers();
                                    int cpuManufacturersListIndex = 1;
                                    for (String cpuManufacturersListValue : cpuManufacturersList) {
                                        if (cpuManufacturersListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.CpuManufacturers.member." + cpuManufacturersListIndex, StringUtils.fromString((String)cpuManufacturersListValue));
                                        }
                                        ++cpuManufacturersListIndex;
                                    }
                                }
                                if ((memoryGiBPerVCpu = instanceRequirements.getMemoryGiBPerVCpu()) != null) {
                                    if (memoryGiBPerVCpu.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Min", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMin()));
                                    }
                                    if (memoryGiBPerVCpu.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.MemoryGiBPerVCpu.Max", StringUtils.fromDouble((Double)memoryGiBPerVCpu.getMax()));
                                    }
                                }
                                if (!instanceRequirements.getExcludedInstanceTypes().isEmpty() || !((SdkInternalList)instanceRequirements.getExcludedInstanceTypes()).isAutoConstruct()) {
                                    SdkInternalList excludedInstanceTypesList = (SdkInternalList)instanceRequirements.getExcludedInstanceTypes();
                                    int excludedInstanceTypesListIndex = 1;
                                    for (String excludedInstanceTypesListValue : excludedInstanceTypesList) {
                                        if (excludedInstanceTypesListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.ExcludedInstanceTypes.member." + excludedInstanceTypesListIndex, StringUtils.fromString((String)excludedInstanceTypesListValue));
                                        }
                                        ++excludedInstanceTypesListIndex;
                                    }
                                }
                                if (!instanceRequirements.getInstanceGenerations().isEmpty() || !((SdkInternalList)instanceRequirements.getInstanceGenerations()).isAutoConstruct()) {
                                    SdkInternalList instanceGenerationsList = (SdkInternalList)instanceRequirements.getInstanceGenerations();
                                    int instanceGenerationsListIndex = 1;
                                    for (String instanceGenerationsListValue : instanceGenerationsList) {
                                        if (instanceGenerationsListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.InstanceGenerations.member." + instanceGenerationsListIndex, StringUtils.fromString((String)instanceGenerationsListValue));
                                        }
                                        ++instanceGenerationsListIndex;
                                    }
                                }
                                if (instanceRequirements.getSpotMaxPricePercentageOverLowestPrice() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.SpotMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getSpotMaxPricePercentageOverLowestPrice()));
                                }
                                if (instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.OnDemandMaxPricePercentageOverLowestPrice", StringUtils.fromInteger((Integer)instanceRequirements.getOnDemandMaxPricePercentageOverLowestPrice()));
                                }
                                if (instanceRequirements.getBareMetal() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.BareMetal", StringUtils.fromString((String)instanceRequirements.getBareMetal()));
                                }
                                if (instanceRequirements.getBurstablePerformance() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.BurstablePerformance", StringUtils.fromString((String)instanceRequirements.getBurstablePerformance()));
                                }
                                if (instanceRequirements.getRequireHibernateSupport() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.RequireHibernateSupport", StringUtils.fromBoolean((Boolean)instanceRequirements.getRequireHibernateSupport()));
                                }
                                if ((networkInterfaceCount = instanceRequirements.getNetworkInterfaceCount()) != null) {
                                    if (networkInterfaceCount.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Min", StringUtils.fromInteger((Integer)networkInterfaceCount.getMin()));
                                    }
                                    if (networkInterfaceCount.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.NetworkInterfaceCount.Max", StringUtils.fromInteger((Integer)networkInterfaceCount.getMax()));
                                    }
                                }
                                if (instanceRequirements.getLocalStorage() != null) {
                                    request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.LocalStorage", StringUtils.fromString((String)instanceRequirements.getLocalStorage()));
                                }
                                if (!instanceRequirements.getLocalStorageTypes().isEmpty() || !((SdkInternalList)instanceRequirements.getLocalStorageTypes()).isAutoConstruct()) {
                                    SdkInternalList localStorageTypesList = (SdkInternalList)instanceRequirements.getLocalStorageTypes();
                                    int localStorageTypesListIndex = 1;
                                    for (String localStorageTypesListValue : localStorageTypesList) {
                                        if (localStorageTypesListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.LocalStorageTypes.member." + localStorageTypesListIndex, StringUtils.fromString((String)localStorageTypesListValue));
                                        }
                                        ++localStorageTypesListIndex;
                                    }
                                }
                                if ((totalLocalStorageGB = instanceRequirements.getTotalLocalStorageGB()) != null) {
                                    if (totalLocalStorageGB.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Min", StringUtils.fromDouble((Double)totalLocalStorageGB.getMin()));
                                    }
                                    if (totalLocalStorageGB.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.TotalLocalStorageGB.Max", StringUtils.fromDouble((Double)totalLocalStorageGB.getMax()));
                                    }
                                }
                                if ((baselineEbsBandwidthMbps = instanceRequirements.getBaselineEbsBandwidthMbps()) != null) {
                                    if (baselineEbsBandwidthMbps.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Min", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMin()));
                                    }
                                    if (baselineEbsBandwidthMbps.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.BaselineEbsBandwidthMbps.Max", StringUtils.fromInteger((Integer)baselineEbsBandwidthMbps.getMax()));
                                    }
                                }
                                if (!instanceRequirements.getAcceleratorTypes().isEmpty() || !((SdkInternalList)instanceRequirements.getAcceleratorTypes()).isAutoConstruct()) {
                                    SdkInternalList acceleratorTypesList = (SdkInternalList)instanceRequirements.getAcceleratorTypes();
                                    int acceleratorTypesListIndex = 1;
                                    for (String acceleratorTypesListValue : acceleratorTypesList) {
                                        if (acceleratorTypesListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorTypes.member." + acceleratorTypesListIndex, StringUtils.fromString((String)acceleratorTypesListValue));
                                        }
                                        ++acceleratorTypesListIndex;
                                    }
                                }
                                if ((acceleratorCount = instanceRequirements.getAcceleratorCount()) != null) {
                                    if (acceleratorCount.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Min", StringUtils.fromInteger((Integer)acceleratorCount.getMin()));
                                    }
                                    if (acceleratorCount.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorCount.Max", StringUtils.fromInteger((Integer)acceleratorCount.getMax()));
                                    }
                                }
                                if (!instanceRequirements.getAcceleratorManufacturers().isEmpty() || !((SdkInternalList)instanceRequirements.getAcceleratorManufacturers()).isAutoConstruct()) {
                                    SdkInternalList acceleratorManufacturersList = (SdkInternalList)instanceRequirements.getAcceleratorManufacturers();
                                    int acceleratorManufacturersListIndex = 1;
                                    for (String acceleratorManufacturersListValue : acceleratorManufacturersList) {
                                        if (acceleratorManufacturersListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorManufacturers.member." + acceleratorManufacturersListIndex, StringUtils.fromString((String)acceleratorManufacturersListValue));
                                        }
                                        ++acceleratorManufacturersListIndex;
                                    }
                                }
                                if (!instanceRequirements.getAcceleratorNames().isEmpty() || !((SdkInternalList)instanceRequirements.getAcceleratorNames()).isAutoConstruct()) {
                                    SdkInternalList acceleratorNamesList = (SdkInternalList)instanceRequirements.getAcceleratorNames();
                                    int acceleratorNamesListIndex = 1;
                                    for (String acceleratorNamesListValue : acceleratorNamesList) {
                                        if (acceleratorNamesListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorNames.member." + acceleratorNamesListIndex, StringUtils.fromString((String)acceleratorNamesListValue));
                                        }
                                        ++acceleratorNamesListIndex;
                                    }
                                }
                                if ((acceleratorTotalMemoryMiB = instanceRequirements.getAcceleratorTotalMemoryMiB()) != null) {
                                    if (acceleratorTotalMemoryMiB.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Min", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMin()));
                                    }
                                    if (acceleratorTotalMemoryMiB.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AcceleratorTotalMemoryMiB.Max", StringUtils.fromInteger((Integer)acceleratorTotalMemoryMiB.getMax()));
                                    }
                                }
                                if ((networkBandwidthGbps = instanceRequirements.getNetworkBandwidthGbps()) != null) {
                                    if (networkBandwidthGbps.getMin() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Min", StringUtils.fromDouble((Double)networkBandwidthGbps.getMin()));
                                    }
                                    if (networkBandwidthGbps.getMax() != null) {
                                        request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.NetworkBandwidthGbps.Max", StringUtils.fromDouble((Double)networkBandwidthGbps.getMax()));
                                    }
                                }
                                if (!instanceRequirements.getAllowedInstanceTypes().isEmpty() || !((SdkInternalList)instanceRequirements.getAllowedInstanceTypes()).isAutoConstruct()) {
                                    SdkInternalList allowedInstanceTypesList = (SdkInternalList)instanceRequirements.getAllowedInstanceTypes();
                                    int allowedInstanceTypesListIndex = 1;
                                    for (String allowedInstanceTypesListValue : allowedInstanceTypesList) {
                                        if (allowedInstanceTypesListValue != null) {
                                            request.addParameter("MixedInstancesPolicy.LaunchTemplate.Overrides.member." + overridesListIndex + ".InstanceRequirements.AllowedInstanceTypes.member." + allowedInstanceTypesListIndex, StringUtils.fromString((String)allowedInstanceTypesListValue));
                                        }
                                        ++allowedInstanceTypesListIndex;
                                    }
                                }
                            }
                        }
                        ++overridesListIndex;
                    }
                }
            }
            if ((instancesDistribution = mixedInstancesPolicy.getInstancesDistribution()) != null) {
                if (instancesDistribution.getOnDemandAllocationStrategy() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getOnDemandAllocationStrategy()));
                }
                if (instancesDistribution.getOnDemandBaseCapacity() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandBaseCapacity()));
                }
                if (instancesDistribution.getOnDemandPercentageAboveBaseCapacity() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.OnDemandPercentageAboveBaseCapacity", StringUtils.fromInteger((Integer)instancesDistribution.getOnDemandPercentageAboveBaseCapacity()));
                }
                if (instancesDistribution.getSpotAllocationStrategy() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotAllocationStrategy", StringUtils.fromString((String)instancesDistribution.getSpotAllocationStrategy()));
                }
                if (instancesDistribution.getSpotInstancePools() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotInstancePools", StringUtils.fromInteger((Integer)instancesDistribution.getSpotInstancePools()));
                }
                if (instancesDistribution.getSpotMaxPrice() != null) {
                    request.addParameter("MixedInstancesPolicy.InstancesDistribution.SpotMaxPrice", StringUtils.fromString((String)instancesDistribution.getSpotMaxPrice()));
                }
            }
        }
        if (updateAutoScalingGroupRequest.getMinSize() != null) {
            request.addParameter("MinSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMinSize()));
        }
        if (updateAutoScalingGroupRequest.getMaxSize() != null) {
            request.addParameter("MaxSize", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMaxSize()));
        }
        if (updateAutoScalingGroupRequest.getDesiredCapacity() != null) {
            request.addParameter("DesiredCapacity", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getDesiredCapacity()));
        }
        if (updateAutoScalingGroupRequest.getDefaultCooldown() != null) {
            request.addParameter("DefaultCooldown", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getDefaultCooldown()));
        }
        if (!updateAutoScalingGroupRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)updateAutoScalingGroupRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)updateAutoScalingGroupRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.member." + availabilityZonesListIndex, StringUtils.fromString((String)availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.getHealthCheckType() != null) {
            request.addParameter("HealthCheckType", StringUtils.fromString((String)updateAutoScalingGroupRequest.getHealthCheckType()));
        }
        if (updateAutoScalingGroupRequest.getHealthCheckGracePeriod() != null) {
            request.addParameter("HealthCheckGracePeriod", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getHealthCheckGracePeriod()));
        }
        if (updateAutoScalingGroupRequest.getPlacementGroup() != null) {
            request.addParameter("PlacementGroup", StringUtils.fromString((String)updateAutoScalingGroupRequest.getPlacementGroup()));
        }
        if (updateAutoScalingGroupRequest.getVPCZoneIdentifier() != null) {
            request.addParameter("VPCZoneIdentifier", StringUtils.fromString((String)updateAutoScalingGroupRequest.getVPCZoneIdentifier()));
        }
        if (!updateAutoScalingGroupRequest.getTerminationPolicies().isEmpty() || !((SdkInternalList)updateAutoScalingGroupRequest.getTerminationPolicies()).isAutoConstruct()) {
            SdkInternalList terminationPoliciesList = (SdkInternalList)updateAutoScalingGroupRequest.getTerminationPolicies();
            int terminationPoliciesListIndex = 1;
            for (String terminationPoliciesListValue : terminationPoliciesList) {
                if (terminationPoliciesListValue != null) {
                    request.addParameter("TerminationPolicies.member." + terminationPoliciesListIndex, StringUtils.fromString((String)terminationPoliciesListValue));
                }
                ++terminationPoliciesListIndex;
            }
        }
        if (updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn() != null) {
            request.addParameter("NewInstancesProtectedFromScaleIn", StringUtils.fromBoolean((Boolean)updateAutoScalingGroupRequest.getNewInstancesProtectedFromScaleIn()));
        }
        if (updateAutoScalingGroupRequest.getServiceLinkedRoleARN() != null) {
            request.addParameter("ServiceLinkedRoleARN", StringUtils.fromString((String)updateAutoScalingGroupRequest.getServiceLinkedRoleARN()));
        }
        if (updateAutoScalingGroupRequest.getMaxInstanceLifetime() != null) {
            request.addParameter("MaxInstanceLifetime", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getMaxInstanceLifetime()));
        }
        if (updateAutoScalingGroupRequest.getCapacityRebalance() != null) {
            request.addParameter("CapacityRebalance", StringUtils.fromBoolean((Boolean)updateAutoScalingGroupRequest.getCapacityRebalance()));
        }
        if (updateAutoScalingGroupRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)updateAutoScalingGroupRequest.getContext()));
        }
        if (updateAutoScalingGroupRequest.getDesiredCapacityType() != null) {
            request.addParameter("DesiredCapacityType", StringUtils.fromString((String)updateAutoScalingGroupRequest.getDesiredCapacityType()));
        }
        if (updateAutoScalingGroupRequest.getDefaultInstanceWarmup() != null) {
            request.addParameter("DefaultInstanceWarmup", StringUtils.fromInteger((Integer)updateAutoScalingGroupRequest.getDefaultInstanceWarmup()));
        }
        return request;
    }
}

