/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.AttachTrafficSourcesRequest;
import com.amazonaws.services.autoscaling.model.TrafficSourceIdentifier;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachTrafficSourcesRequestMarshaller
implements Marshaller<Request<AttachTrafficSourcesRequest>, AttachTrafficSourcesRequest> {
    public Request<AttachTrafficSourcesRequest> marshall(AttachTrafficSourcesRequest attachTrafficSourcesRequest) {
        if (attachTrafficSourcesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachTrafficSourcesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachTrafficSources");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachTrafficSourcesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)attachTrafficSourcesRequest.getAutoScalingGroupName()));
        }
        if (!attachTrafficSourcesRequest.getTrafficSources().isEmpty() || !((SdkInternalList)attachTrafficSourcesRequest.getTrafficSources()).isAutoConstruct()) {
            SdkInternalList trafficSourcesList = (SdkInternalList)attachTrafficSourcesRequest.getTrafficSources();
            int trafficSourcesListIndex = 1;
            for (TrafficSourceIdentifier trafficSourcesListValue : trafficSourcesList) {
                if (trafficSourcesListValue != null) {
                    if (trafficSourcesListValue.getIdentifier() != null) {
                        request.addParameter("TrafficSources.member." + trafficSourcesListIndex + ".Identifier", StringUtils.fromString((String)trafficSourcesListValue.getIdentifier()));
                    }
                    if (trafficSourcesListValue.getType() != null) {
                        request.addParameter("TrafficSources.member." + trafficSourcesListIndex + ".Type", StringUtils.fromString((String)trafficSourcesListValue.getType()));
                    }
                }
                ++trafficSourcesListIndex;
            }
        }
        return request;
    }
}

