/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.autoscaling.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.autoscaling.model.AttachInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachInstancesRequestMarshaller
implements Marshaller<Request<AttachInstancesRequest>, AttachInstancesRequest> {
    public Request<AttachInstancesRequest> marshall(AttachInstancesRequest attachInstancesRequest) {
        if (attachInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachInstancesRequest, "AmazonAutoScaling");
        request.addParameter("Action", "AttachInstances");
        request.addParameter("Version", "2011-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (!attachInstancesRequest.getInstanceIds().isEmpty() || !((SdkInternalList)attachInstancesRequest.getInstanceIds()).isAutoConstruct()) {
            SdkInternalList instanceIdsList = (SdkInternalList)attachInstancesRequest.getInstanceIds();
            int instanceIdsListIndex = 1;
            for (String instanceIdsListValue : instanceIdsList) {
                if (instanceIdsListValue != null) {
                    request.addParameter("InstanceIds.member." + instanceIdsListIndex, StringUtils.fromString((String)instanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (attachInstancesRequest.getAutoScalingGroupName() != null) {
            request.addParameter("AutoScalingGroupName", StringUtils.fromString((String)attachInstancesRequest.getAutoScalingGroupName()));
        }
        return request;
    }
}

