/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * Contains the details for a transformer object. A transformer describes how to process the incoming EDI documents and
 * extract the necessary information to the output file.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/b2bi-2022-06-23/TransformerSummary" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class TransformerSummary implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     */
    private String transformerId;
    /**
     * <p>
     * Returns the descriptive name for the transformer.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     */
    private String fileFormat;
    /**
     * <p>
     * Returns the name of the mapping template for the transformer. This template is used to convert the input document
     * into the correct set of objects.
     * </p>
     */
    private String mappingTemplate;
    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     */
    private String status;
    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     */
    private EdiType ediType;
    /**
     * <p>
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     */
    private String sampleDocument;
    /**
     * <p>
     * Returns a timestamp indicating when the transformer was created. For example,
     * <code>2023-07-20T19:58:44.624Z</code>.
     * </p>
     */
    private java.util.Date createdAt;
    /**
     * <p>
     * Returns a timestamp representing the date and time for the most recent change for the transformer object.
     * </p>
     */
    private java.util.Date modifiedAt;

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @param transformerId
     *        Returns the system-assigned unique identifier for the transformer.
     */

    public void setTransformerId(String transformerId) {
        this.transformerId = transformerId;
    }

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @return Returns the system-assigned unique identifier for the transformer.
     */

    public String getTransformerId() {
        return this.transformerId;
    }

    /**
     * <p>
     * Returns the system-assigned unique identifier for the transformer.
     * </p>
     * 
     * @param transformerId
     *        Returns the system-assigned unique identifier for the transformer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withTransformerId(String transformerId) {
        setTransformerId(transformerId);
        return this;
    }

    /**
     * <p>
     * Returns the descriptive name for the transformer.
     * </p>
     * 
     * @param name
     *        Returns the descriptive name for the transformer.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * Returns the descriptive name for the transformer.
     * </p>
     * 
     * @return Returns the descriptive name for the transformer.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * Returns the descriptive name for the transformer.
     * </p>
     * 
     * @param name
     *        Returns the descriptive name for the transformer.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * 
     * @param fileFormat
     *        Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *        <code>XML</code>.
     * @see FileFormat
     */

    public void setFileFormat(String fileFormat) {
        this.fileFormat = fileFormat;
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * 
     * @return Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *         <code>XML</code>.
     * @see FileFormat
     */

    public String getFileFormat() {
        return this.fileFormat;
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * 
     * @param fileFormat
     *        Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *        <code>XML</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FileFormat
     */

    public TransformerSummary withFileFormat(String fileFormat) {
        setFileFormat(fileFormat);
        return this;
    }

    /**
     * <p>
     * Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     * <code>XML</code>.
     * </p>
     * 
     * @param fileFormat
     *        Returns that the currently supported file formats for EDI transformations are <code>JSON</code> and
     *        <code>XML</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see FileFormat
     */

    public TransformerSummary withFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat.toString();
        return this;
    }

    /**
     * <p>
     * Returns the name of the mapping template for the transformer. This template is used to convert the input document
     * into the correct set of objects.
     * </p>
     * 
     * @param mappingTemplate
     *        Returns the name of the mapping template for the transformer. This template is used to convert the input
     *        document into the correct set of objects.
     */

    public void setMappingTemplate(String mappingTemplate) {
        this.mappingTemplate = mappingTemplate;
    }

    /**
     * <p>
     * Returns the name of the mapping template for the transformer. This template is used to convert the input document
     * into the correct set of objects.
     * </p>
     * 
     * @return Returns the name of the mapping template for the transformer. This template is used to convert the input
     *         document into the correct set of objects.
     */

    public String getMappingTemplate() {
        return this.mappingTemplate;
    }

    /**
     * <p>
     * Returns the name of the mapping template for the transformer. This template is used to convert the input document
     * into the correct set of objects.
     * </p>
     * 
     * @param mappingTemplate
     *        Returns the name of the mapping template for the transformer. This template is used to convert the input
     *        document into the correct set of objects.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withMappingTemplate(String mappingTemplate) {
        setMappingTemplate(mappingTemplate);
        return this;
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * 
     * @param status
     *        Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *        <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>
     *        .
     * @see TransformerStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * 
     * @return Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *         <code>inactive</code>. For the transformer to be used in a capability, its status must
     *         <code>active</code>.
     * @see TransformerStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * 
     * @param status
     *        Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *        <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>
     *        .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformerStatus
     */

    public TransformerSummary withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     * <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>.
     * </p>
     * 
     * @param status
     *        Returns the state of the newly created transformer. The transformer can be either <code>active</code> or
     *        <code>inactive</code>. For the transformer to be used in a capability, its status must <code>active</code>
     *        .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see TransformerStatus
     */

    public TransformerSummary withStatus(TransformerStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @param ediType
     *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *        supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */

    public void setEdiType(EdiType ediType) {
        this.ediType = ediType;
    }

    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @return Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *         supported. X12 is a set of standards and corresponding messages that define specific business documents.
     */

    public EdiType getEdiType() {
        return this.ediType;
    }

    /**
     * <p>
     * Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     * supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * </p>
     * 
     * @param ediType
     *        Returns the details for the EDI standard that is being used for the transformer. Currently, only X12 is
     *        supported. X12 is a set of standards and corresponding messages that define specific business documents.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withEdiType(EdiType ediType) {
        setEdiType(ediType);
        return this;
    }

    /**
     * <p>
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @param sampleDocument
     *        Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     */

    public void setSampleDocument(String sampleDocument) {
        this.sampleDocument = sampleDocument;
    }

    /**
     * <p>
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @return Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     */

    public String getSampleDocument() {
        return this.sampleDocument;
    }

    /**
     * <p>
     * Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * </p>
     * 
     * @param sampleDocument
     *        Returns a sample EDI document that is used by a transformer as a guide for processing the EDI data.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withSampleDocument(String sampleDocument) {
        setSampleDocument(sampleDocument);
        return this;
    }

    /**
     * <p>
     * Returns a timestamp indicating when the transformer was created. For example,
     * <code>2023-07-20T19:58:44.624Z</code>.
     * </p>
     * 
     * @param createdAt
     *        Returns a timestamp indicating when the transformer was created. For example,
     *        <code>2023-07-20T19:58:44.624Z</code>.
     */

    public void setCreatedAt(java.util.Date createdAt) {
        this.createdAt = createdAt;
    }

    /**
     * <p>
     * Returns a timestamp indicating when the transformer was created. For example,
     * <code>2023-07-20T19:58:44.624Z</code>.
     * </p>
     * 
     * @return Returns a timestamp indicating when the transformer was created. For example,
     *         <code>2023-07-20T19:58:44.624Z</code>.
     */

    public java.util.Date getCreatedAt() {
        return this.createdAt;
    }

    /**
     * <p>
     * Returns a timestamp indicating when the transformer was created. For example,
     * <code>2023-07-20T19:58:44.624Z</code>.
     * </p>
     * 
     * @param createdAt
     *        Returns a timestamp indicating when the transformer was created. For example,
     *        <code>2023-07-20T19:58:44.624Z</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withCreatedAt(java.util.Date createdAt) {
        setCreatedAt(createdAt);
        return this;
    }

    /**
     * <p>
     * Returns a timestamp representing the date and time for the most recent change for the transformer object.
     * </p>
     * 
     * @param modifiedAt
     *        Returns a timestamp representing the date and time for the most recent change for the transformer object.
     */

    public void setModifiedAt(java.util.Date modifiedAt) {
        this.modifiedAt = modifiedAt;
    }

    /**
     * <p>
     * Returns a timestamp representing the date and time for the most recent change for the transformer object.
     * </p>
     * 
     * @return Returns a timestamp representing the date and time for the most recent change for the transformer object.
     */

    public java.util.Date getModifiedAt() {
        return this.modifiedAt;
    }

    /**
     * <p>
     * Returns a timestamp representing the date and time for the most recent change for the transformer object.
     * </p>
     * 
     * @param modifiedAt
     *        Returns a timestamp representing the date and time for the most recent change for the transformer object.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public TransformerSummary withModifiedAt(java.util.Date modifiedAt) {
        setModifiedAt(modifiedAt);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getTransformerId() != null)
            sb.append("TransformerId: ").append(getTransformerId()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getFileFormat() != null)
            sb.append("FileFormat: ").append(getFileFormat()).append(",");
        if (getMappingTemplate() != null)
            sb.append("MappingTemplate: ").append(getMappingTemplate()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getEdiType() != null)
            sb.append("EdiType: ").append(getEdiType()).append(",");
        if (getSampleDocument() != null)
            sb.append("SampleDocument: ").append(getSampleDocument()).append(",");
        if (getCreatedAt() != null)
            sb.append("CreatedAt: ").append(getCreatedAt()).append(",");
        if (getModifiedAt() != null)
            sb.append("ModifiedAt: ").append(getModifiedAt());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof TransformerSummary == false)
            return false;
        TransformerSummary other = (TransformerSummary) obj;
        if (other.getTransformerId() == null ^ this.getTransformerId() == null)
            return false;
        if (other.getTransformerId() != null && other.getTransformerId().equals(this.getTransformerId()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getFileFormat() == null ^ this.getFileFormat() == null)
            return false;
        if (other.getFileFormat() != null && other.getFileFormat().equals(this.getFileFormat()) == false)
            return false;
        if (other.getMappingTemplate() == null ^ this.getMappingTemplate() == null)
            return false;
        if (other.getMappingTemplate() != null && other.getMappingTemplate().equals(this.getMappingTemplate()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getEdiType() == null ^ this.getEdiType() == null)
            return false;
        if (other.getEdiType() != null && other.getEdiType().equals(this.getEdiType()) == false)
            return false;
        if (other.getSampleDocument() == null ^ this.getSampleDocument() == null)
            return false;
        if (other.getSampleDocument() != null && other.getSampleDocument().equals(this.getSampleDocument()) == false)
            return false;
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null)
            return false;
        if (other.getCreatedAt() != null && other.getCreatedAt().equals(this.getCreatedAt()) == false)
            return false;
        if (other.getModifiedAt() == null ^ this.getModifiedAt() == null)
            return false;
        if (other.getModifiedAt() != null && other.getModifiedAt().equals(this.getModifiedAt()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getTransformerId() == null) ? 0 : getTransformerId().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getFileFormat() == null) ? 0 : getFileFormat().hashCode());
        hashCode = prime * hashCode + ((getMappingTemplate() == null) ? 0 : getMappingTemplate().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getEdiType() == null) ? 0 : getEdiType().hashCode());
        hashCode = prime * hashCode + ((getSampleDocument() == null) ? 0 : getSampleDocument().hashCode());
        hashCode = prime * hashCode + ((getCreatedAt() == null) ? 0 : getCreatedAt().hashCode());
        hashCode = prime * hashCode + ((getModifiedAt() == null) ? 0 : getModifiedAt().hashCode());
        return hashCode;
    }

    @Override
    public TransformerSummary clone() {
        try {
            return (TransformerSummary) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.b2bi.model.transform.TransformerSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
