/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.b2bi;

import javax.annotation.Generated;

import com.amazonaws.services.b2bi.model.*;

/**
 * Abstract implementation of {@code AWSB2BiAsync}. Convenient method forms pass through to the corresponding overload
 * that takes a request object and an {@code AsyncHandler}, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSB2BiAsync extends AbstractAWSB2Bi implements AWSB2BiAsync {

    protected AbstractAWSB2BiAsync() {
    }

    @Override
    public java.util.concurrent.Future<CreateCapabilityResult> createCapabilityAsync(CreateCapabilityRequest request) {

        return createCapabilityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateCapabilityResult> createCapabilityAsync(CreateCapabilityRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateCapabilityRequest, CreateCapabilityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreatePartnershipResult> createPartnershipAsync(CreatePartnershipRequest request) {

        return createPartnershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreatePartnershipResult> createPartnershipAsync(CreatePartnershipRequest request,
            com.amazonaws.handlers.AsyncHandler<CreatePartnershipRequest, CreatePartnershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request) {

        return createProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateProfileResult> createProfileAsync(CreateProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateProfileRequest, CreateProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<CreateTransformerResult> createTransformerAsync(CreateTransformerRequest request) {

        return createTransformerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<CreateTransformerResult> createTransformerAsync(CreateTransformerRequest request,
            com.amazonaws.handlers.AsyncHandler<CreateTransformerRequest, CreateTransformerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteCapabilityResult> deleteCapabilityAsync(DeleteCapabilityRequest request) {

        return deleteCapabilityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteCapabilityResult> deleteCapabilityAsync(DeleteCapabilityRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteCapabilityRequest, DeleteCapabilityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeletePartnershipResult> deletePartnershipAsync(DeletePartnershipRequest request) {

        return deletePartnershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeletePartnershipResult> deletePartnershipAsync(DeletePartnershipRequest request,
            com.amazonaws.handlers.AsyncHandler<DeletePartnershipRequest, DeletePartnershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request) {

        return deleteProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteProfileResult> deleteProfileAsync(DeleteProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteProfileRequest, DeleteProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<DeleteTransformerResult> deleteTransformerAsync(DeleteTransformerRequest request) {

        return deleteTransformerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<DeleteTransformerResult> deleteTransformerAsync(DeleteTransformerRequest request,
            com.amazonaws.handlers.AsyncHandler<DeleteTransformerRequest, DeleteTransformerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetCapabilityResult> getCapabilityAsync(GetCapabilityRequest request) {

        return getCapabilityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetCapabilityResult> getCapabilityAsync(GetCapabilityRequest request,
            com.amazonaws.handlers.AsyncHandler<GetCapabilityRequest, GetCapabilityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetPartnershipResult> getPartnershipAsync(GetPartnershipRequest request) {

        return getPartnershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetPartnershipResult> getPartnershipAsync(GetPartnershipRequest request,
            com.amazonaws.handlers.AsyncHandler<GetPartnershipRequest, GetPartnershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetProfileResult> getProfileAsync(GetProfileRequest request) {

        return getProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetProfileResult> getProfileAsync(GetProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<GetProfileRequest, GetProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTransformerResult> getTransformerAsync(GetTransformerRequest request) {

        return getTransformerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTransformerResult> getTransformerAsync(GetTransformerRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTransformerRequest, GetTransformerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<GetTransformerJobResult> getTransformerJobAsync(GetTransformerJobRequest request) {

        return getTransformerJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<GetTransformerJobResult> getTransformerJobAsync(GetTransformerJobRequest request,
            com.amazonaws.handlers.AsyncHandler<GetTransformerJobRequest, GetTransformerJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListCapabilitiesResult> listCapabilitiesAsync(ListCapabilitiesRequest request) {

        return listCapabilitiesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListCapabilitiesResult> listCapabilitiesAsync(ListCapabilitiesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListCapabilitiesRequest, ListCapabilitiesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListPartnershipsResult> listPartnershipsAsync(ListPartnershipsRequest request) {

        return listPartnershipsAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListPartnershipsResult> listPartnershipsAsync(ListPartnershipsRequest request,
            com.amazonaws.handlers.AsyncHandler<ListPartnershipsRequest, ListPartnershipsResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request) {

        return listProfilesAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListProfilesResult> listProfilesAsync(ListProfilesRequest request,
            com.amazonaws.handlers.AsyncHandler<ListProfilesRequest, ListProfilesResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request) {

        return listTagsForResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTagsForResourceResult> listTagsForResourceAsync(ListTagsForResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTagsForResourceRequest, ListTagsForResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<ListTransformersResult> listTransformersAsync(ListTransformersRequest request) {

        return listTransformersAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<ListTransformersResult> listTransformersAsync(ListTransformersRequest request,
            com.amazonaws.handlers.AsyncHandler<ListTransformersRequest, ListTransformersResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<StartTransformerJobResult> startTransformerJobAsync(StartTransformerJobRequest request) {

        return startTransformerJobAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<StartTransformerJobResult> startTransformerJobAsync(StartTransformerJobRequest request,
            com.amazonaws.handlers.AsyncHandler<StartTransformerJobRequest, StartTransformerJobResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request) {

        return tagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TagResourceResult> tagResourceAsync(TagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<TagResourceRequest, TagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TestMappingResult> testMappingAsync(TestMappingRequest request) {

        return testMappingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TestMappingResult> testMappingAsync(TestMappingRequest request,
            com.amazonaws.handlers.AsyncHandler<TestMappingRequest, TestMappingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<TestParsingResult> testParsingAsync(TestParsingRequest request) {

        return testParsingAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<TestParsingResult> testParsingAsync(TestParsingRequest request,
            com.amazonaws.handlers.AsyncHandler<TestParsingRequest, TestParsingResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request) {

        return untagResourceAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UntagResourceResult> untagResourceAsync(UntagResourceRequest request,
            com.amazonaws.handlers.AsyncHandler<UntagResourceRequest, UntagResourceResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateCapabilityResult> updateCapabilityAsync(UpdateCapabilityRequest request) {

        return updateCapabilityAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateCapabilityResult> updateCapabilityAsync(UpdateCapabilityRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateCapabilityRequest, UpdateCapabilityResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdatePartnershipResult> updatePartnershipAsync(UpdatePartnershipRequest request) {

        return updatePartnershipAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdatePartnershipResult> updatePartnershipAsync(UpdatePartnershipRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdatePartnershipRequest, UpdatePartnershipResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request) {

        return updateProfileAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateProfileResult> updateProfileAsync(UpdateProfileRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateProfileRequest, UpdateProfileResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public java.util.concurrent.Future<UpdateTransformerResult> updateTransformerAsync(UpdateTransformerRequest request) {

        return updateTransformerAsync(request, null);
    }

    @Override
    public java.util.concurrent.Future<UpdateTransformerResult> updateTransformerAsync(UpdateTransformerRequest request,
            com.amazonaws.handlers.AsyncHandler<UpdateTransformerRequest, UpdateTransformerResult> asyncHandler) {

        throw new java.lang.UnsupportedOperationException();
    }

}
