/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.b2bi.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.b2bi.model.CapabilityConfiguration;
import com.amazonaws.services.b2bi.model.CapabilityType;
import com.amazonaws.services.b2bi.model.S3Location;
import com.amazonaws.services.b2bi.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateCapabilityRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String type;
    private CapabilityConfiguration configuration;
    private List<S3Location> instructionsDocuments;
    private String clientToken;
    private List<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCapabilityRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateCapabilityRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public CreateCapabilityRequest withType(CapabilityType type) {
        this.type = type.toString();
        return this;
    }

    public void setConfiguration(CapabilityConfiguration configuration) {
        this.configuration = configuration;
    }

    public CapabilityConfiguration getConfiguration() {
        return this.configuration;
    }

    public CreateCapabilityRequest withConfiguration(CapabilityConfiguration configuration) {
        this.setConfiguration(configuration);
        return this;
    }

    public List<S3Location> getInstructionsDocuments() {
        return this.instructionsDocuments;
    }

    public void setInstructionsDocuments(Collection<S3Location> instructionsDocuments) {
        if (instructionsDocuments == null) {
            this.instructionsDocuments = null;
            return;
        }
        this.instructionsDocuments = new ArrayList<S3Location>(instructionsDocuments);
    }

    public CreateCapabilityRequest withInstructionsDocuments(S3Location ... instructionsDocuments) {
        if (this.instructionsDocuments == null) {
            this.setInstructionsDocuments(new ArrayList<S3Location>(instructionsDocuments.length));
        }
        for (S3Location ele : instructionsDocuments) {
            this.instructionsDocuments.add(ele);
        }
        return this;
    }

    public CreateCapabilityRequest withInstructionsDocuments(Collection<S3Location> instructionsDocuments) {
        this.setInstructionsDocuments(instructionsDocuments);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateCapabilityRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateCapabilityRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateCapabilityRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getConfiguration() != null) {
            sb.append("Configuration: ").append(this.getConfiguration()).append(",");
        }
        if (this.getInstructionsDocuments() != null) {
            sb.append("InstructionsDocuments: ").append(this.getInstructionsDocuments()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapabilityRequest)) {
            return false;
        }
        CreateCapabilityRequest other = (CreateCapabilityRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getConfiguration() == null ^ this.getConfiguration() == null) {
            return false;
        }
        if (other.getConfiguration() != null && !other.getConfiguration().equals(this.getConfiguration())) {
            return false;
        }
        if (other.getInstructionsDocuments() == null ^ this.getInstructionsDocuments() == null) {
            return false;
        }
        if (other.getInstructionsDocuments() != null && !other.getInstructionsDocuments().equals(this.getInstructionsDocuments())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getConfiguration() == null ? 0 : this.getConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getInstructionsDocuments() == null ? 0 : this.getInstructionsDocuments().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateCapabilityRequest clone() {
        return (CreateCapabilityRequest)super.clone();
    }
}

