/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.transform.ReportSettingMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReportSetting
implements Serializable,
Cloneable,
StructuredPojo {
    private String reportTemplate;
    private List<String> frameworkArns;
    private Integer numberOfFrameworks;

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public String getReportTemplate() {
        return this.reportTemplate;
    }

    public ReportSetting withReportTemplate(String reportTemplate) {
        this.setReportTemplate(reportTemplate);
        return this;
    }

    public List<String> getFrameworkArns() {
        return this.frameworkArns;
    }

    public void setFrameworkArns(Collection<String> frameworkArns) {
        if (frameworkArns == null) {
            this.frameworkArns = null;
            return;
        }
        this.frameworkArns = new ArrayList<String>(frameworkArns);
    }

    public ReportSetting withFrameworkArns(String ... frameworkArns) {
        if (this.frameworkArns == null) {
            this.setFrameworkArns(new ArrayList<String>(frameworkArns.length));
        }
        for (String ele : frameworkArns) {
            this.frameworkArns.add(ele);
        }
        return this;
    }

    public ReportSetting withFrameworkArns(Collection<String> frameworkArns) {
        this.setFrameworkArns(frameworkArns);
        return this;
    }

    public void setNumberOfFrameworks(Integer numberOfFrameworks) {
        this.numberOfFrameworks = numberOfFrameworks;
    }

    public Integer getNumberOfFrameworks() {
        return this.numberOfFrameworks;
    }

    public ReportSetting withNumberOfFrameworks(Integer numberOfFrameworks) {
        this.setNumberOfFrameworks(numberOfFrameworks);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getReportTemplate() != null) {
            sb.append("ReportTemplate: ").append(this.getReportTemplate()).append(",");
        }
        if (this.getFrameworkArns() != null) {
            sb.append("FrameworkArns: ").append(this.getFrameworkArns()).append(",");
        }
        if (this.getNumberOfFrameworks() != null) {
            sb.append("NumberOfFrameworks: ").append(this.getNumberOfFrameworks());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReportSetting)) {
            return false;
        }
        ReportSetting other = (ReportSetting)obj;
        if (other.getReportTemplate() == null ^ this.getReportTemplate() == null) {
            return false;
        }
        if (other.getReportTemplate() != null && !other.getReportTemplate().equals(this.getReportTemplate())) {
            return false;
        }
        if (other.getFrameworkArns() == null ^ this.getFrameworkArns() == null) {
            return false;
        }
        if (other.getFrameworkArns() != null && !other.getFrameworkArns().equals(this.getFrameworkArns())) {
            return false;
        }
        if (other.getNumberOfFrameworks() == null ^ this.getNumberOfFrameworks() == null) {
            return false;
        }
        return other.getNumberOfFrameworks() == null || other.getNumberOfFrameworks().equals(this.getNumberOfFrameworks());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getReportTemplate() == null ? 0 : this.getReportTemplate().hashCode());
        hashCode = 31 * hashCode + (this.getFrameworkArns() == null ? 0 : this.getFrameworkArns().hashCode());
        hashCode = 31 * hashCode + (this.getNumberOfFrameworks() == null ? 0 : this.getNumberOfFrameworks().hashCode());
        return hashCode;
    }

    public ReportSetting clone() {
        try {
            return (ReportSetting)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReportSettingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

