/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.ReportSetting;
import java.util.List;

@SdkInternalApi
public class ReportSettingMarshaller {
    private static final MarshallingInfo<String> REPORTTEMPLATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ReportTemplate").build();
    private static final MarshallingInfo<List> FRAMEWORKARNS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FrameworkArns").build();
    private static final MarshallingInfo<Integer> NUMBEROFFRAMEWORKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfFrameworks").build();
    private static final ReportSettingMarshaller instance = new ReportSettingMarshaller();

    public static ReportSettingMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReportSetting reportSetting, ProtocolMarshaller protocolMarshaller) {
        if (reportSetting == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)reportSetting.getReportTemplate(), REPORTTEMPLATE_BINDING);
            protocolMarshaller.marshall(reportSetting.getFrameworkArns(), FRAMEWORKARNS_BINDING);
            protocolMarshaller.marshall((Object)reportSetting.getNumberOfFrameworks(), NUMBEROFFRAMEWORKS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

