/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.backup.model.BackupJob;
import java.util.Date;
import java.util.Map;

@SdkInternalApi
public class BackupJobMarshaller {
    private static final MarshallingInfo<String> ACCOUNTID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AccountId").build();
    private static final MarshallingInfo<String> BACKUPJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupJobId").build();
    private static final MarshallingInfo<String> BACKUPVAULTNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupVaultName").build();
    private static final MarshallingInfo<String> BACKUPVAULTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupVaultArn").build();
    private static final MarshallingInfo<String> RECOVERYPOINTARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RecoveryPointArn").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceArn").build();
    private static final MarshallingInfo<Date> CREATIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> COMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CompletionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("State").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StatusMessage").build();
    private static final MarshallingInfo<String> PERCENTDONE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("PercentDone").build();
    private static final MarshallingInfo<Long> BACKUPSIZEINBYTES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupSizeInBytes").build();
    private static final MarshallingInfo<String> IAMROLEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IamRoleArn").build();
    private static final MarshallingInfo<StructuredPojo> CREATEDBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreatedBy").build();
    private static final MarshallingInfo<Date> EXPECTEDCOMPLETIONDATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ExpectedCompletionDate").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> STARTBY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartBy").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RESOURCETYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceType").build();
    private static final MarshallingInfo<Long> BYTESTRANSFERRED_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BytesTransferred").build();
    private static final MarshallingInfo<Map> BACKUPOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupOptions").build();
    private static final MarshallingInfo<String> BACKUPTYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("BackupType").build();
    private static final MarshallingInfo<String> PARENTJOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ParentJobId").build();
    private static final MarshallingInfo<Boolean> ISPARENT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("IsParent").build();
    private static final MarshallingInfo<String> RESOURCENAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceName").build();
    private static final BackupJobMarshaller instance = new BackupJobMarshaller();

    public static BackupJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(BackupJob backupJob, ProtocolMarshaller protocolMarshaller) {
        if (backupJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)backupJob.getAccountId(), ACCOUNTID_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBackupJobId(), BACKUPJOBID_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBackupVaultName(), BACKUPVAULTNAME_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBackupVaultArn(), BACKUPVAULTARN_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getRecoveryPointArn(), RECOVERYPOINTARN_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getResourceArn(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getCreationDate(), CREATIONDATE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getCompletionDate(), COMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getState(), STATE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getPercentDone(), PERCENTDONE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBackupSizeInBytes(), BACKUPSIZEINBYTES_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getIamRoleArn(), IAMROLEARN_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getCreatedBy(), CREATEDBY_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getExpectedCompletionDate(), EXPECTEDCOMPLETIONDATE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getStartBy(), STARTBY_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getResourceType(), RESOURCETYPE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBytesTransferred(), BYTESTRANSFERRED_BINDING);
            protocolMarshaller.marshall(backupJob.getBackupOptions(), BACKUPOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getBackupType(), BACKUPTYPE_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getParentJobId(), PARENTJOBID_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getIsParent(), ISPARENT_BINDING);
            protocolMarshaller.marshall((Object)backupJob.getResourceName(), RESOURCENAME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

