/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.backup.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * BackupRule JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class BackupRuleJsonUnmarshaller implements Unmarshaller<BackupRule, JsonUnmarshallerContext> {

    public BackupRule unmarshall(JsonUnmarshallerContext context) throws Exception {
        BackupRule backupRule = new BackupRule();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return null;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("RuleName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setRuleName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("TargetBackupVaultName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setTargetBackupVaultName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("ScheduleExpression", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setScheduleExpression(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("StartWindowMinutes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setStartWindowMinutes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("CompletionWindowMinutes", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setCompletionWindowMinutes(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Lifecycle", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setLifecycle(LifecycleJsonUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("RecoveryPointTags", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setRecoveryPointTags(new MapUnmarshaller<String, String>(context.getUnmarshaller(String.class), context
                            .getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("RuleId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setRuleId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CopyActions", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setCopyActions(new ListUnmarshaller<CopyAction>(CopyActionJsonUnmarshaller.getInstance())

                    .unmarshall(context));
                }
                if (context.testExpression("EnableContinuousBackup", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setEnableContinuousBackup(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("ScheduleExpressionTimezone", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    backupRule.setScheduleExpressionTimezone(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return backupRule;
    }

    private static BackupRuleJsonUnmarshaller instance;

    public static BackupRuleJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new BackupRuleJsonUnmarshaller();
        return instance;
    }
}
