/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model.transform;

import java.math.*;

import javax.annotation.Generated;

import com.amazonaws.services.backup.model.*;
import com.amazonaws.transform.SimpleTypeJsonUnmarshallers.*;
import com.amazonaws.transform.*;

import com.fasterxml.jackson.core.JsonToken;
import static com.fasterxml.jackson.core.JsonToken.*;

/**
 * DescribeBackupVaultResult JSON Unmarshaller
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeBackupVaultResultJsonUnmarshaller implements Unmarshaller<DescribeBackupVaultResult, JsonUnmarshallerContext> {

    public DescribeBackupVaultResult unmarshall(JsonUnmarshallerContext context) throws Exception {
        DescribeBackupVaultResult describeBackupVaultResult = new DescribeBackupVaultResult();

        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;

        JsonToken token = context.getCurrentToken();
        if (token == null)
            token = context.nextToken();
        if (token == VALUE_NULL) {
            return describeBackupVaultResult;
        }

        boolean knownMember;

        while (true) {
            if (token == null)
                break;

            knownMember = false;

            if (token == FIELD_NAME || token == START_OBJECT) {
                if (context.testExpression("BackupVaultName", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setBackupVaultName(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("BackupVaultArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setBackupVaultArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("VaultType", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setVaultType(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("EncryptionKeyArn", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setEncryptionKeyArn(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("CreationDate", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setCreationDate(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (context.testExpression("CreatorRequestId", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setCreatorRequestId(context.getUnmarshaller(String.class).unmarshall(context));
                }
                if (context.testExpression("NumberOfRecoveryPoints", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setNumberOfRecoveryPoints(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("Locked", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setLocked(context.getUnmarshaller(Boolean.class).unmarshall(context));
                }
                if (context.testExpression("MinRetentionDays", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setMinRetentionDays(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("MaxRetentionDays", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setMaxRetentionDays(context.getUnmarshaller(Long.class).unmarshall(context));
                }
                if (context.testExpression("LockDate", targetDepth)) {
                    knownMember = true;
                    context.nextToken();
                    describeBackupVaultResult.setLockDate(DateJsonUnmarshallerFactory.getInstance("unixTimestamp").unmarshall(context));
                }
                if (token == FIELD_NAME && !knownMember) {
                    context.nextToken();
                    com.amazonaws.transform.UnknownMemberJsonUnmarshaller.getInstance().unmarshall(context);
                }
            } else if (token == END_ARRAY || token == END_OBJECT) {
                if (context.getLastParsedParentElement() == null || context.getLastParsedParentElement().equals(currentParentElement)) {
                    if (context.getCurrentDepth() <= originalDepth)
                        break;
                }
            }
            token = context.nextToken();
        }

        return describeBackupVaultResult;
    }

    private static DescribeBackupVaultResultJsonUnmarshaller instance;

    public static DescribeBackupVaultResultJsonUnmarshaller getInstance() {
        if (instance == null)
            instance = new DescribeBackupVaultResultJsonUnmarshaller();
        return instance;
    }
}
