/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.backup.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/backup-2018-11-15/DescribeRecoveryPoint" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class DescribeRecoveryPointResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     */
    private String recoveryPointArn;
    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     */
    private String backupVaultName;
    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     */
    private String backupVaultArn;
    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed
     * up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is
     * restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
     * </p>
     */
    private String sourceBackupVaultArn;
    /**
     * <p>
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * </p>
     */
    private String resourceArn;
    /**
     * <p>
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store
     * (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     */
    private String resourceType;
    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * used to create it.
     * </p>
     */
    private RecoveryPointCreator createdBy;
    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     */
    private String iamRoleArn;
    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     */
    private String status;
    /**
     * <p>
     * A status message explaining the status of the recovery point.
     * </p>
     */
    private String statusMessage;
    /**
     * <p>
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     */
    private java.util.Date creationDate;
    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal
     * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     */
    private java.util.Date completionDate;
    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     */
    private Long backupSizeInBytes;
    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     */
    private CalculatedLifecycle calculatedLifecycle;
    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     * the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition
     * to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     */
    private Lifecycle lifecycle;
    /**
     * <p>
     * The server-side encryption key used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     */
    private String encryptionKeyArn;
    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     */
    private Boolean isEncrypted;
    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     */
    private String storageClass;
    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     */
    private java.util.Date lastRestoreTime;
    /**
     * <p>
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     */
    private String parentRecoveryPointArn;
    /**
     * <p>
     * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to
     * a composite (parent) stack. The ID is transferred from the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     * > logical ID</a> within a stack.
     * </p>
     */
    private String compositeMemberIdentifier;
    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     */
    private Boolean isParent;
    /**
     * <p>
     * This is the non-unique name of the resource that belongs to the specified backup.
     * </p>
     */
    private String resourceName;
    /**
     * <p>
     * This is the type of vault in which the described recovery point is stored.
     * </p>
     */
    private String vaultType;

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @param recoveryPointArn
     *        An ARN that uniquely identifies a recovery point; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */

    public void setRecoveryPointArn(String recoveryPointArn) {
        this.recoveryPointArn = recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */

    public String getRecoveryPointArn() {
        return this.recoveryPointArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @param recoveryPointArn
     *        An ARN that uniquely identifies a recovery point; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withRecoveryPointArn(String recoveryPointArn) {
        setRecoveryPointArn(recoveryPointArn);
        return this;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @param backupVaultName
     *        The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *        unique to the account used to create them and the Region where they are created. They consist of lowercase
     *        letters, numbers, and hyphens.
     */

    public void setBackupVaultName(String backupVaultName) {
        this.backupVaultName = backupVaultName;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @return The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *         unique to the account used to create them and the Region where they are created. They consist of
     *         lowercase letters, numbers, and hyphens.
     */

    public String getBackupVaultName() {
        return this.backupVaultName;
    }

    /**
     * <p>
     * The name of a logical container where backups are stored. Backup vaults are identified by names that are unique
     * to the account used to create them and the Region where they are created. They consist of lowercase letters,
     * numbers, and hyphens.
     * </p>
     * 
     * @param backupVaultName
     *        The name of a logical container where backups are stored. Backup vaults are identified by names that are
     *        unique to the account used to create them and the Region where they are created. They consist of lowercase
     *        letters, numbers, and hyphens.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withBackupVaultName(String backupVaultName) {
        setBackupVaultName(backupVaultName);
        return this;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @param backupVaultArn
     *        An ARN that uniquely identifies a backup vault; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */

    public void setBackupVaultArn(String backupVaultArn) {
        this.backupVaultArn = backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @return An ARN that uniquely identifies a backup vault; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     */

    public String getBackupVaultArn() {
        return this.backupVaultArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a backup vault; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * </p>
     * 
     * @param backupVaultArn
     *        An ARN that uniquely identifies a backup vault; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:vault:aBackupVault</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withBackupVaultArn(String backupVaultArn) {
        setBackupVaultArn(backupVaultArn);
        return this;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed
     * up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is
     * restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
     * </p>
     * 
     * @param sourceBackupVaultArn
     *        An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally
     *        backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the
     *        recovery is restored to the same Amazon Web Services account or Region, this value will be
     *        <code>null</code>.
     */

    public void setSourceBackupVaultArn(String sourceBackupVaultArn) {
        this.sourceBackupVaultArn = sourceBackupVaultArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed
     * up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is
     * restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally
     *         backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the
     *         recovery is restored to the same Amazon Web Services account or Region, this value will be
     *         <code>null</code>.
     */

    public String getSourceBackupVaultArn() {
        return this.sourceBackupVaultArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally backed
     * up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the recovery is
     * restored to the same Amazon Web Services account or Region, this value will be <code>null</code>.
     * </p>
     * 
     * @param sourceBackupVaultArn
     *        An Amazon Resource Name (ARN) that uniquely identifies the source vault where the resource was originally
     *        backed up in; for example, <code>arn:aws:backup:us-east-1:123456789012:vault:BackupVault</code>. If the
     *        recovery is restored to the same Amazon Web Services account or Region, this value will be
     *        <code>null</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withSourceBackupVaultArn(String sourceBackupVaultArn) {
        setSourceBackupVaultArn(sourceBackupVaultArn);
        return this;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @param resourceArn
     *        An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     */

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @return An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     */

    public String getResourceArn() {
        return this.resourceArn;
    }

    /**
     * <p>
     * An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * </p>
     * 
     * @param resourceArn
     *        An ARN that uniquely identifies a saved resource. The format of the ARN depends on the resource type.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withResourceArn(String resourceArn) {
        setResourceArn(resourceArn);
        return this;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store
     * (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @param resourceType
     *        The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block
     *        Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store
     * (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic
     *         Block Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     */

    public String getResourceType() {
        return this.resourceType;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block Store
     * (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * </p>
     * 
     * @param resourceType
     *        The type of Amazon Web Services resource to save as a recovery point; for example, an Amazon Elastic Block
     *        Store (Amazon EBS) volume or an Amazon Relational Database Service (Amazon RDS) database.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withResourceType(String resourceType) {
        setResourceType(resourceType);
        return this;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * used to create it.
     * </p>
     * 
     * @param createdBy
     *        Contains identifying information about the creation of a recovery point, including the
     *        <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *        <code>BackupRuleId</code> of the backup plan used to create it.
     */

    public void setCreatedBy(RecoveryPointCreator createdBy) {
        this.createdBy = createdBy;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * used to create it.
     * </p>
     * 
     * @return Contains identifying information about the creation of a recovery point, including the
     *         <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *         <code>BackupRuleId</code> of the backup plan used to create it.
     */

    public RecoveryPointCreator getCreatedBy() {
        return this.createdBy;
    }

    /**
     * <p>
     * Contains identifying information about the creation of a recovery point, including the <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and <code>BackupRuleId</code> of the backup plan
     * used to create it.
     * </p>
     * 
     * @param createdBy
     *        Contains identifying information about the creation of a recovery point, including the
     *        <code>BackupPlanArn</code>, <code>BackupPlanId</code>, <code>BackupPlanVersion</code>, and
     *        <code>BackupRuleId</code> of the backup plan used to create it.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withCreatedBy(RecoveryPointCreator createdBy) {
        setCreatedBy(createdBy);
        return this;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @param iamRoleArn
     *        Specifies the IAM role ARN used to create the target recovery point; for example,
     *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */

    public void setIamRoleArn(String iamRoleArn) {
        this.iamRoleArn = iamRoleArn;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return Specifies the IAM role ARN used to create the target recovery point; for example,
     *         <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    /**
     * <p>
     * Specifies the IAM role ARN used to create the target recovery point; for example,
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @param iamRoleArn
     *        Specifies the IAM role ARN used to create the target recovery point; for example,
     *        <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withIamRoleArn(String iamRoleArn) {
        setIamRoleArn(iamRoleArn);
        return this;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * 
     * @param status
     *        A status code specifying the state of the recovery point.</p>
     *        <p>
     *        <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *        closed. To increase your backup plan window using the API, see <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *        >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *        editing your backup plan.
     *        </p>
     *        <p>
     *        <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *        Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see
     *        <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *        Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     *        </p>
     *        <p>
     *        <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *        the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *        versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *        in place by Backup.
     *        </p>
     *        <p>
     *        To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *        versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *        running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *        status do not need to be deleted.
     *        </p>
     *        <p>
     *        For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *        misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *        recovery point status and check SAP HANA for details.
     * @see RecoveryPointStatus
     */

    public void setStatus(String status) {
        this.status = status;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * 
     * @return A status code specifying the state of the recovery point.</p>
     *         <p>
     *         <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *         closed. To increase your backup plan window using the API, see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *         >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *         editing your backup plan.
     *         </p>
     *         <p>
     *         <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *         Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points,
     *         see <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *         Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting
     *         started</i>.
     *         </p>
     *         <p>
     *         <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *         the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *         versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *         in place by Backup.
     *         </p>
     *         <p>
     *         To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *         versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *         running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *         status do not need to be deleted.
     *         </p>
     *         <p>
     *         For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *         misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *         recovery point status and check SAP HANA for details.
     * @see RecoveryPointStatus
     */

    public String getStatus() {
        return this.status;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * 
     * @param status
     *        A status code specifying the state of the recovery point.</p>
     *        <p>
     *        <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *        closed. To increase your backup plan window using the API, see <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *        >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *        editing your backup plan.
     *        </p>
     *        <p>
     *        <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *        Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see
     *        <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *        Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     *        </p>
     *        <p>
     *        <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *        the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *        versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *        in place by Backup.
     *        </p>
     *        <p>
     *        To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *        versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *        running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *        status do not need to be deleted.
     *        </p>
     *        <p>
     *        For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *        misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *        recovery point status and check SAP HANA for details.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecoveryPointStatus
     */

    public DescribeRecoveryPointResult withStatus(String status) {
        setStatus(status);
        return this;
    }

    /**
     * <p>
     * A status code specifying the state of the recovery point.
     * </p>
     * <p>
     * <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window closed.
     * To increase your backup plan window using the API, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html">UpdateBackupPlan</a>. You
     * can also increase your backup plan window using the Console by choosing and editing your backup plan.
     * </p>
     * <p>
     * <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but Backup lacks
     * permission or is otherwise unable to delete it. To manually delete these recovery points, see <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups"> Step 3:
     * Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     * </p>
     * <p>
     * <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes the
     * continuous backup to be disabled. This can be caused by the removal of permissions, turning off versioning,
     * turning off events being sent to EventBridge, or disabling the EventBridge rules that are put in place by Backup.
     * </p>
     * <p>
     * To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that versioning is
     * enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule running will result
     * in a new continuous recovery point being created. The recovery points with STOPPED status do not need to be
     * deleted.
     * </p>
     * <p>
     * For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application misconfiguration,
     * or backup failure. To ensure that future continuous backups succeed, refer to the recovery point status and check
     * SAP HANA for details.
     * </p>
     * 
     * @param status
     *        A status code specifying the state of the recovery point.</p>
     *        <p>
     *        <code>PARTIAL</code> status indicates Backup could not create the recovery point before the backup window
     *        closed. To increase your backup plan window using the API, see <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateBackupPlan.html"
     *        >UpdateBackupPlan</a>. You can also increase your backup plan window using the Console by choosing and
     *        editing your backup plan.
     *        </p>
     *        <p>
     *        <code>EXPIRED</code> status indicates that the recovery point has exceeded its retention period, but
     *        Backup lacks permission or is otherwise unable to delete it. To manually delete these recovery points, see
     *        <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/gs-cleanup-resources.html#cleanup-backups">
     *        Step 3: Delete the recovery points</a> in the <i>Clean up resources</i> section of <i>Getting started</i>.
     *        </p>
     *        <p>
     *        <code>STOPPED</code> status occurs on a continuous backup where a user has taken some action that causes
     *        the continuous backup to be disabled. This can be caused by the removal of permissions, turning off
     *        versioning, turning off events being sent to EventBridge, or disabling the EventBridge rules that are put
     *        in place by Backup.
     *        </p>
     *        <p>
     *        To resolve <code>STOPPED</code> status, ensure that all requested permissions are in place and that
     *        versioning is enabled on the S3 bucket. Once these conditions are met, the next instance of a backup rule
     *        running will result in a new continuous recovery point being created. The recovery points with STOPPED
     *        status do not need to be deleted.
     *        </p>
     *        <p>
     *        For SAP HANA on Amazon EC2 <code>STOPPED</code> status occurs due to user action, application
     *        misconfiguration, or backup failure. To ensure that future continuous backups succeed, refer to the
     *        recovery point status and check SAP HANA for details.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see RecoveryPointStatus
     */

    public DescribeRecoveryPointResult withStatus(RecoveryPointStatus status) {
        this.status = status.toString();
        return this;
    }

    /**
     * <p>
     * A status message explaining the status of the recovery point.
     * </p>
     * 
     * @param statusMessage
     *        A status message explaining the status of the recovery point.
     */

    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    /**
     * <p>
     * A status message explaining the status of the recovery point.
     * </p>
     * 
     * @return A status message explaining the status of the recovery point.
     */

    public String getStatusMessage() {
        return this.statusMessage;
    }

    /**
     * <p>
     * A status message explaining the status of the recovery point.
     * </p>
     * 
     * @param statusMessage
     *        A status message explaining the status of the recovery point.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withStatusMessage(String statusMessage) {
        setStatusMessage(statusMessage);
        return this;
    }

    /**
     * <p>
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param creationDate
     *        The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
     *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *        represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public void setCreationDate(java.util.Date creationDate) {
        this.creationDate = creationDate;
    }

    /**
     * <p>
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
     *         The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public java.util.Date getCreationDate() {
        return this.creationDate;
    }

    /**
     * <p>
     * The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param creationDate
     *        The date and time that a recovery point is created, in Unix format and Coordinated Universal Time (UTC).
     *        The value of <code>CreationDate</code> is accurate to milliseconds. For example, the value 1516925490.087
     *        represents Friday, January 26, 2018 12:11:30.087 AM.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withCreationDate(java.util.Date creationDate) {
        setCreationDate(creationDate);
        return this;
    }

    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal
     * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param completionDate
     *        The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
     *        Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *        the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public void setCompletionDate(java.util.Date completionDate) {
        this.completionDate = completionDate;
    }

    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal
     * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
     *         Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *         the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public java.util.Date getCompletionDate() {
        return this.completionDate;
    }

    /**
     * <p>
     * The date and time that a job to create a recovery point is completed, in Unix format and Coordinated Universal
     * Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example, the value
     * 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param completionDate
     *        The date and time that a job to create a recovery point is completed, in Unix format and Coordinated
     *        Universal Time (UTC). The value of <code>CompletionDate</code> is accurate to milliseconds. For example,
     *        the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withCompletionDate(java.util.Date completionDate) {
        setCompletionDate(completionDate);
        return this;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @param backupSizeInBytes
     *        The size, in bytes, of a backup.
     */

    public void setBackupSizeInBytes(Long backupSizeInBytes) {
        this.backupSizeInBytes = backupSizeInBytes;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @return The size, in bytes, of a backup.
     */

    public Long getBackupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    /**
     * <p>
     * The size, in bytes, of a backup.
     * </p>
     * 
     * @param backupSizeInBytes
     *        The size, in bytes, of a backup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withBackupSizeInBytes(Long backupSizeInBytes) {
        setBackupSizeInBytes(backupSizeInBytes);
        return this;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @param calculatedLifecycle
     *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *        <code>MoveToColdStorageAt</code> timestamps.
     */

    public void setCalculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
        this.calculatedLifecycle = calculatedLifecycle;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @return A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *         <code>MoveToColdStorageAt</code> timestamps.
     */

    public CalculatedLifecycle getCalculatedLifecycle() {
        return this.calculatedLifecycle;
    }

    /**
     * <p>
     * A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and <code>MoveToColdStorageAt</code>
     * timestamps.
     * </p>
     * 
     * @param calculatedLifecycle
     *        A <code>CalculatedLifecycle</code> object containing <code>DeleteAt</code> and
     *        <code>MoveToColdStorageAt</code> timestamps.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withCalculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
        setCalculatedLifecycle(calculatedLifecycle);
        return this;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     * the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition
     * to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * 
     * @param lifecycle
     *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
     *        Backup transitions and expires backups automatically according to the lifecycle that you define.</p>
     *        <p>
     *        Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     *        Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days”
     *        setting. The “transition to cold after days” setting cannot be changed after a backup has been
     *        transitioned to cold.
     *        </p>
     *        <p>
     *        Resource types that are able to be transitioned to cold storage are listed in the
     *        "Lifecycle to cold storage" section of the <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource">
     *        Feature availability by resource</a> table. Backup ignores this expression for other resource types.
     */

    public void setLifecycle(Lifecycle lifecycle) {
        this.lifecycle = lifecycle;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     * the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition
     * to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * 
     * @return The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
     *         Backup transitions and expires backups automatically according to the lifecycle that you define.</p>
     *         <p>
     *         Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     *         Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days”
     *         setting. The “transition to cold after days” setting cannot be changed after a backup has been
     *         transitioned to cold.
     *         </p>
     *         <p>
     *         Resource types that are able to be transitioned to cold storage are listed in the
     *         "Lifecycle to cold storage" section of the <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource">
     *         Feature availability by resource</a> table. Backup ignores this expression for other resource types.
     */

    public Lifecycle getLifecycle() {
        return this.lifecycle;
    }

    /**
     * <p>
     * The lifecycle defines when a protected resource is transitioned to cold storage and when it expires. Backup
     * transitions and expires backups automatically according to the lifecycle that you define.
     * </p>
     * <p>
     * Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days. Therefore,
     * the “retention” setting must be 90 days greater than the “transition to cold after days” setting. The “transition
     * to cold after days” setting cannot be changed after a backup has been transitioned to cold.
     * </p>
     * <p>
     * Resource types that are able to be transitioned to cold storage are listed in the "Lifecycle to cold storage"
     * section of the <a
     * href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource"> Feature
     * availability by resource</a> table. Backup ignores this expression for other resource types.
     * </p>
     * 
     * @param lifecycle
     *        The lifecycle defines when a protected resource is transitioned to cold storage and when it expires.
     *        Backup transitions and expires backups automatically according to the lifecycle that you define.</p>
     *        <p>
     *        Backups that are transitioned to cold storage must be stored in cold storage for a minimum of 90 days.
     *        Therefore, the “retention” setting must be 90 days greater than the “transition to cold after days”
     *        setting. The “transition to cold after days” setting cannot be changed after a backup has been
     *        transitioned to cold.
     *        </p>
     *        <p>
     *        Resource types that are able to be transitioned to cold storage are listed in the
     *        "Lifecycle to cold storage" section of the <a
     *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/whatisbackup.html#features-by-resource">
     *        Feature availability by resource</a> table. Backup ignores this expression for other resource types.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withLifecycle(Lifecycle lifecycle) {
        setLifecycle(lifecycle);
        return this;
    }

    /**
     * <p>
     * The server-side encryption key used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @param encryptionKeyArn
     *        The server-side encryption key used to protect your backups; for example,
     *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */

    public void setEncryptionKeyArn(String encryptionKeyArn) {
        this.encryptionKeyArn = encryptionKeyArn;
    }

    /**
     * <p>
     * The server-side encryption key used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @return The server-side encryption key used to protect your backups; for example,
     *         <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     */

    public String getEncryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    /**
     * <p>
     * The server-side encryption key used to protect your backups; for example,
     * <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * </p>
     * 
     * @param encryptionKeyArn
     *        The server-side encryption key used to protect your backups; for example,
     *        <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withEncryptionKeyArn(String encryptionKeyArn) {
        setEncryptionKeyArn(encryptionKeyArn);
        return this;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @param isEncrypted
     *        A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *        <code>FALSE</code> if the recovery point is not encrypted.
     */

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @return A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *         <code>FALSE</code> if the recovery point is not encrypted.
     */

    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @param isEncrypted
     *        A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *        <code>FALSE</code> if the recovery point is not encrypted.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withIsEncrypted(Boolean isEncrypted) {
        setIsEncrypted(isEncrypted);
        return this;
    }

    /**
     * <p>
     * A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     * <code>FALSE</code> if the recovery point is not encrypted.
     * </p>
     * 
     * @return A Boolean value that is returned as <code>TRUE</code> if the specified recovery point is encrypted, or
     *         <code>FALSE</code> if the recovery point is not encrypted.
     */

    public Boolean isEncrypted() {
        return this.isEncrypted;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * 
     * @param storageClass
     *        Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>
     *        .
     * @see StorageClass
     */

    public void setStorageClass(String storageClass) {
        this.storageClass = storageClass;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * 
     * @return Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or
     *         <code>COLD</code>.
     * @see StorageClass
     */

    public String getStorageClass() {
        return this.storageClass;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * 
     * @param storageClass
     *        Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>
     *        .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StorageClass
     */

    public DescribeRecoveryPointResult withStorageClass(String storageClass) {
        setStorageClass(storageClass);
        return this;
    }

    /**
     * <p>
     * Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>.
     * </p>
     * 
     * @param storageClass
     *        Specifies the storage class of the recovery point. Valid values are <code>WARM</code> or <code>COLD</code>
     *        .
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see StorageClass
     */

    public DescribeRecoveryPointResult withStorageClass(StorageClass storageClass) {
        this.storageClass = storageClass.toString();
        return this;
    }

    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param lastRestoreTime
     *        The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time
     *        (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
     *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public void setLastRestoreTime(java.util.Date lastRestoreTime) {
        this.lastRestoreTime = lastRestoreTime;
    }

    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */

    public java.util.Date getLastRestoreTime() {
        return this.lastRestoreTime;
    }

    /**
     * <p>
     * The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time (UTC).
     * The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @param lastRestoreTime
     *        The date and time that a recovery point was last restored, in Unix format and Coordinated Universal Time
     *        (UTC). The value of <code>LastRestoreTime</code> is accurate to milliseconds. For example, the value
     *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withLastRestoreTime(java.util.Date lastRestoreTime) {
        setLastRestoreTime(lastRestoreTime);
        return this;
    }

    /**
     * <p>
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @param parentRecoveryPointArn
     *        This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */

    public void setParentRecoveryPointArn(String parentRecoveryPointArn) {
        this.parentRecoveryPointArn = parentRecoveryPointArn;
    }

    /**
     * <p>
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @return This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     */

    public String getParentRecoveryPointArn() {
        return this.parentRecoveryPointArn;
    }

    /**
     * <p>
     * This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * </p>
     * 
     * @param parentRecoveryPointArn
     *        This is an ARN that uniquely identifies a parent (composite) recovery point; for example,
     *        <code>arn:aws:backup:us-east-1:123456789012:recovery-point:1EB3B5E7-9EB0-435A-A80B-108B488B0D45</code>.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withParentRecoveryPointArn(String parentRecoveryPointArn) {
        setParentRecoveryPointArn(parentRecoveryPointArn);
        return this;
    }

    /**
     * <p>
     * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to
     * a composite (parent) stack. The ID is transferred from the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     * > logical ID</a> within a stack.
     * </p>
     * 
     * @param compositeMemberIdentifier
     *        This is the identifier of a resource within a composite group, such as nested (child) recovery point
     *        belonging to a composite (parent) stack. The ID is transferred from the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     *        > logical ID</a> within a stack.
     */

    public void setCompositeMemberIdentifier(String compositeMemberIdentifier) {
        this.compositeMemberIdentifier = compositeMemberIdentifier;
    }

    /**
     * <p>
     * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to
     * a composite (parent) stack. The ID is transferred from the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     * > logical ID</a> within a stack.
     * </p>
     * 
     * @return This is the identifier of a resource within a composite group, such as nested (child) recovery point
     *         belonging to a composite (parent) stack. The ID is transferred from the <a href=
     *         "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     *         > logical ID</a> within a stack.
     */

    public String getCompositeMemberIdentifier() {
        return this.compositeMemberIdentifier;
    }

    /**
     * <p>
     * This is the identifier of a resource within a composite group, such as nested (child) recovery point belonging to
     * a composite (parent) stack. The ID is transferred from the <a href=
     * "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     * > logical ID</a> within a stack.
     * </p>
     * 
     * @param compositeMemberIdentifier
     *        This is the identifier of a resource within a composite group, such as nested (child) recovery point
     *        belonging to a composite (parent) stack. The ID is transferred from the <a href=
     *        "https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/resources-section-structure.html#resources-section-structure-syntax"
     *        > logical ID</a> within a stack.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withCompositeMemberIdentifier(String compositeMemberIdentifier) {
        setCompositeMemberIdentifier(compositeMemberIdentifier);
        return this;
    }

    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     * 
     * @param isParent
     *        This returns the boolean value that a recovery point is a parent (composite) job.
     */

    public void setIsParent(Boolean isParent) {
        this.isParent = isParent;
    }

    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     * 
     * @return This returns the boolean value that a recovery point is a parent (composite) job.
     */

    public Boolean getIsParent() {
        return this.isParent;
    }

    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     * 
     * @param isParent
     *        This returns the boolean value that a recovery point is a parent (composite) job.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withIsParent(Boolean isParent) {
        setIsParent(isParent);
        return this;
    }

    /**
     * <p>
     * This returns the boolean value that a recovery point is a parent (composite) job.
     * </p>
     * 
     * @return This returns the boolean value that a recovery point is a parent (composite) job.
     */

    public Boolean isParent() {
        return this.isParent;
    }

    /**
     * <p>
     * This is the non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @param resourceName
     *        This is the non-unique name of the resource that belongs to the specified backup.
     */

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    /**
     * <p>
     * This is the non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return This is the non-unique name of the resource that belongs to the specified backup.
     */

    public String getResourceName() {
        return this.resourceName;
    }

    /**
     * <p>
     * This is the non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @param resourceName
     *        This is the non-unique name of the resource that belongs to the specified backup.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public DescribeRecoveryPointResult withResourceName(String resourceName) {
        setResourceName(resourceName);
        return this;
    }

    /**
     * <p>
     * This is the type of vault in which the described recovery point is stored.
     * </p>
     * 
     * @param vaultType
     *        This is the type of vault in which the described recovery point is stored.
     * @see VaultType
     */

    public void setVaultType(String vaultType) {
        this.vaultType = vaultType;
    }

    /**
     * <p>
     * This is the type of vault in which the described recovery point is stored.
     * </p>
     * 
     * @return This is the type of vault in which the described recovery point is stored.
     * @see VaultType
     */

    public String getVaultType() {
        return this.vaultType;
    }

    /**
     * <p>
     * This is the type of vault in which the described recovery point is stored.
     * </p>
     * 
     * @param vaultType
     *        This is the type of vault in which the described recovery point is stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VaultType
     */

    public DescribeRecoveryPointResult withVaultType(String vaultType) {
        setVaultType(vaultType);
        return this;
    }

    /**
     * <p>
     * This is the type of vault in which the described recovery point is stored.
     * </p>
     * 
     * @param vaultType
     *        This is the type of vault in which the described recovery point is stored.
     * @return Returns a reference to this object so that method calls can be chained together.
     * @see VaultType
     */

    public DescribeRecoveryPointResult withVaultType(VaultType vaultType) {
        this.vaultType = vaultType.toString();
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getRecoveryPointArn() != null)
            sb.append("RecoveryPointArn: ").append(getRecoveryPointArn()).append(",");
        if (getBackupVaultName() != null)
            sb.append("BackupVaultName: ").append(getBackupVaultName()).append(",");
        if (getBackupVaultArn() != null)
            sb.append("BackupVaultArn: ").append(getBackupVaultArn()).append(",");
        if (getSourceBackupVaultArn() != null)
            sb.append("SourceBackupVaultArn: ").append(getSourceBackupVaultArn()).append(",");
        if (getResourceArn() != null)
            sb.append("ResourceArn: ").append(getResourceArn()).append(",");
        if (getResourceType() != null)
            sb.append("ResourceType: ").append(getResourceType()).append(",");
        if (getCreatedBy() != null)
            sb.append("CreatedBy: ").append(getCreatedBy()).append(",");
        if (getIamRoleArn() != null)
            sb.append("IamRoleArn: ").append(getIamRoleArn()).append(",");
        if (getStatus() != null)
            sb.append("Status: ").append(getStatus()).append(",");
        if (getStatusMessage() != null)
            sb.append("StatusMessage: ").append(getStatusMessage()).append(",");
        if (getCreationDate() != null)
            sb.append("CreationDate: ").append(getCreationDate()).append(",");
        if (getCompletionDate() != null)
            sb.append("CompletionDate: ").append(getCompletionDate()).append(",");
        if (getBackupSizeInBytes() != null)
            sb.append("BackupSizeInBytes: ").append(getBackupSizeInBytes()).append(",");
        if (getCalculatedLifecycle() != null)
            sb.append("CalculatedLifecycle: ").append(getCalculatedLifecycle()).append(",");
        if (getLifecycle() != null)
            sb.append("Lifecycle: ").append(getLifecycle()).append(",");
        if (getEncryptionKeyArn() != null)
            sb.append("EncryptionKeyArn: ").append(getEncryptionKeyArn()).append(",");
        if (getIsEncrypted() != null)
            sb.append("IsEncrypted: ").append(getIsEncrypted()).append(",");
        if (getStorageClass() != null)
            sb.append("StorageClass: ").append(getStorageClass()).append(",");
        if (getLastRestoreTime() != null)
            sb.append("LastRestoreTime: ").append(getLastRestoreTime()).append(",");
        if (getParentRecoveryPointArn() != null)
            sb.append("ParentRecoveryPointArn: ").append(getParentRecoveryPointArn()).append(",");
        if (getCompositeMemberIdentifier() != null)
            sb.append("CompositeMemberIdentifier: ").append(getCompositeMemberIdentifier()).append(",");
        if (getIsParent() != null)
            sb.append("IsParent: ").append(getIsParent()).append(",");
        if (getResourceName() != null)
            sb.append("ResourceName: ").append(getResourceName()).append(",");
        if (getVaultType() != null)
            sb.append("VaultType: ").append(getVaultType());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof DescribeRecoveryPointResult == false)
            return false;
        DescribeRecoveryPointResult other = (DescribeRecoveryPointResult) obj;
        if (other.getRecoveryPointArn() == null ^ this.getRecoveryPointArn() == null)
            return false;
        if (other.getRecoveryPointArn() != null && other.getRecoveryPointArn().equals(this.getRecoveryPointArn()) == false)
            return false;
        if (other.getBackupVaultName() == null ^ this.getBackupVaultName() == null)
            return false;
        if (other.getBackupVaultName() != null && other.getBackupVaultName().equals(this.getBackupVaultName()) == false)
            return false;
        if (other.getBackupVaultArn() == null ^ this.getBackupVaultArn() == null)
            return false;
        if (other.getBackupVaultArn() != null && other.getBackupVaultArn().equals(this.getBackupVaultArn()) == false)
            return false;
        if (other.getSourceBackupVaultArn() == null ^ this.getSourceBackupVaultArn() == null)
            return false;
        if (other.getSourceBackupVaultArn() != null && other.getSourceBackupVaultArn().equals(this.getSourceBackupVaultArn()) == false)
            return false;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null)
            return false;
        if (other.getResourceArn() != null && other.getResourceArn().equals(this.getResourceArn()) == false)
            return false;
        if (other.getResourceType() == null ^ this.getResourceType() == null)
            return false;
        if (other.getResourceType() != null && other.getResourceType().equals(this.getResourceType()) == false)
            return false;
        if (other.getCreatedBy() == null ^ this.getCreatedBy() == null)
            return false;
        if (other.getCreatedBy() != null && other.getCreatedBy().equals(this.getCreatedBy()) == false)
            return false;
        if (other.getIamRoleArn() == null ^ this.getIamRoleArn() == null)
            return false;
        if (other.getIamRoleArn() != null && other.getIamRoleArn().equals(this.getIamRoleArn()) == false)
            return false;
        if (other.getStatus() == null ^ this.getStatus() == null)
            return false;
        if (other.getStatus() != null && other.getStatus().equals(this.getStatus()) == false)
            return false;
        if (other.getStatusMessage() == null ^ this.getStatusMessage() == null)
            return false;
        if (other.getStatusMessage() != null && other.getStatusMessage().equals(this.getStatusMessage()) == false)
            return false;
        if (other.getCreationDate() == null ^ this.getCreationDate() == null)
            return false;
        if (other.getCreationDate() != null && other.getCreationDate().equals(this.getCreationDate()) == false)
            return false;
        if (other.getCompletionDate() == null ^ this.getCompletionDate() == null)
            return false;
        if (other.getCompletionDate() != null && other.getCompletionDate().equals(this.getCompletionDate()) == false)
            return false;
        if (other.getBackupSizeInBytes() == null ^ this.getBackupSizeInBytes() == null)
            return false;
        if (other.getBackupSizeInBytes() != null && other.getBackupSizeInBytes().equals(this.getBackupSizeInBytes()) == false)
            return false;
        if (other.getCalculatedLifecycle() == null ^ this.getCalculatedLifecycle() == null)
            return false;
        if (other.getCalculatedLifecycle() != null && other.getCalculatedLifecycle().equals(this.getCalculatedLifecycle()) == false)
            return false;
        if (other.getLifecycle() == null ^ this.getLifecycle() == null)
            return false;
        if (other.getLifecycle() != null && other.getLifecycle().equals(this.getLifecycle()) == false)
            return false;
        if (other.getEncryptionKeyArn() == null ^ this.getEncryptionKeyArn() == null)
            return false;
        if (other.getEncryptionKeyArn() != null && other.getEncryptionKeyArn().equals(this.getEncryptionKeyArn()) == false)
            return false;
        if (other.getIsEncrypted() == null ^ this.getIsEncrypted() == null)
            return false;
        if (other.getIsEncrypted() != null && other.getIsEncrypted().equals(this.getIsEncrypted()) == false)
            return false;
        if (other.getStorageClass() == null ^ this.getStorageClass() == null)
            return false;
        if (other.getStorageClass() != null && other.getStorageClass().equals(this.getStorageClass()) == false)
            return false;
        if (other.getLastRestoreTime() == null ^ this.getLastRestoreTime() == null)
            return false;
        if (other.getLastRestoreTime() != null && other.getLastRestoreTime().equals(this.getLastRestoreTime()) == false)
            return false;
        if (other.getParentRecoveryPointArn() == null ^ this.getParentRecoveryPointArn() == null)
            return false;
        if (other.getParentRecoveryPointArn() != null && other.getParentRecoveryPointArn().equals(this.getParentRecoveryPointArn()) == false)
            return false;
        if (other.getCompositeMemberIdentifier() == null ^ this.getCompositeMemberIdentifier() == null)
            return false;
        if (other.getCompositeMemberIdentifier() != null && other.getCompositeMemberIdentifier().equals(this.getCompositeMemberIdentifier()) == false)
            return false;
        if (other.getIsParent() == null ^ this.getIsParent() == null)
            return false;
        if (other.getIsParent() != null && other.getIsParent().equals(this.getIsParent()) == false)
            return false;
        if (other.getResourceName() == null ^ this.getResourceName() == null)
            return false;
        if (other.getResourceName() != null && other.getResourceName().equals(this.getResourceName()) == false)
            return false;
        if (other.getVaultType() == null ^ this.getVaultType() == null)
            return false;
        if (other.getVaultType() != null && other.getVaultType().equals(this.getVaultType()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getRecoveryPointArn() == null) ? 0 : getRecoveryPointArn().hashCode());
        hashCode = prime * hashCode + ((getBackupVaultName() == null) ? 0 : getBackupVaultName().hashCode());
        hashCode = prime * hashCode + ((getBackupVaultArn() == null) ? 0 : getBackupVaultArn().hashCode());
        hashCode = prime * hashCode + ((getSourceBackupVaultArn() == null) ? 0 : getSourceBackupVaultArn().hashCode());
        hashCode = prime * hashCode + ((getResourceArn() == null) ? 0 : getResourceArn().hashCode());
        hashCode = prime * hashCode + ((getResourceType() == null) ? 0 : getResourceType().hashCode());
        hashCode = prime * hashCode + ((getCreatedBy() == null) ? 0 : getCreatedBy().hashCode());
        hashCode = prime * hashCode + ((getIamRoleArn() == null) ? 0 : getIamRoleArn().hashCode());
        hashCode = prime * hashCode + ((getStatus() == null) ? 0 : getStatus().hashCode());
        hashCode = prime * hashCode + ((getStatusMessage() == null) ? 0 : getStatusMessage().hashCode());
        hashCode = prime * hashCode + ((getCreationDate() == null) ? 0 : getCreationDate().hashCode());
        hashCode = prime * hashCode + ((getCompletionDate() == null) ? 0 : getCompletionDate().hashCode());
        hashCode = prime * hashCode + ((getBackupSizeInBytes() == null) ? 0 : getBackupSizeInBytes().hashCode());
        hashCode = prime * hashCode + ((getCalculatedLifecycle() == null) ? 0 : getCalculatedLifecycle().hashCode());
        hashCode = prime * hashCode + ((getLifecycle() == null) ? 0 : getLifecycle().hashCode());
        hashCode = prime * hashCode + ((getEncryptionKeyArn() == null) ? 0 : getEncryptionKeyArn().hashCode());
        hashCode = prime * hashCode + ((getIsEncrypted() == null) ? 0 : getIsEncrypted().hashCode());
        hashCode = prime * hashCode + ((getStorageClass() == null) ? 0 : getStorageClass().hashCode());
        hashCode = prime * hashCode + ((getLastRestoreTime() == null) ? 0 : getLastRestoreTime().hashCode());
        hashCode = prime * hashCode + ((getParentRecoveryPointArn() == null) ? 0 : getParentRecoveryPointArn().hashCode());
        hashCode = prime * hashCode + ((getCompositeMemberIdentifier() == null) ? 0 : getCompositeMemberIdentifier().hashCode());
        hashCode = prime * hashCode + ((getIsParent() == null) ? 0 : getIsParent().hashCode());
        hashCode = prime * hashCode + ((getResourceName() == null) ? 0 : getResourceName().hashCode());
        hashCode = prime * hashCode + ((getVaultType() == null) ? 0 : getVaultType().hashCode());
        return hashCode;
    }

    @Override
    public DescribeRecoveryPointResult clone() {
        try {
            return (DescribeRecoveryPointResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
