/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.backup.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.backup.model.KeyValue;

@SdkInternalApi
public class KeyValueMarshaller {
    private static final MarshallingInfo<String> KEY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Key").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final KeyValueMarshaller instance = new KeyValueMarshaller();

    public static KeyValueMarshaller getInstance() {
        return instance;
    }

    public void marshall(KeyValue keyValue, ProtocolMarshaller protocolMarshaller) {
        if (keyValue == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)keyValue.getKey(), KEY_BINDING);
            protocolMarshaller.marshall((Object)keyValue.getValue(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

